/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.generator;

import com.streamscape.Trace;
import com.streamscape.runtime.mf.operation.edl.generator.SdoCommon;
import com.streamscape.runtime.mf.operation.edl.generator.SdoConstructor;
import com.streamscape.runtime.mf.operation.edl.generator.SdoField;
import com.streamscape.runtime.mf.operation.edl.generator.SdoMethod;
import com.streamscape.runtime.mf.operation.edl.generator.SdoNestedClass;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SdoClass
extends SdoCommon {
    private String className;
    private String packageName;
    private String superclass;
    private Set<String> interfaces = new TreeSet<String>();
    private List<SdoField> fields = new ArrayList<SdoField>();
    private List<SdoConstructor> constructors = new ArrayList<SdoConstructor>();
    private List<SdoMethod> methods = new ArrayList<SdoMethod>();
    private List<SdoNestedClass> nestedClasses = new ArrayList<SdoNestedClass>();

    public SdoClass(String className) {
        this("", className);
    }

    public SdoClass(String packageName, String className) {
        this.className = className;
        this.packageName = packageName;
        if (this.packageName == null) {
            this.packageName = "";
        }
        this.setModifier("public");
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullClassName() {
        if (this.packageName.length() == 0) {
            return this.className;
        }
        return this.packageName + "." + this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = new TreeSet<String>();
        Collections.addAll(this.interfaces, interfaces);
    }

    public void addInterfaces(String[] interfaces) {
        Collections.addAll(this.interfaces, interfaces);
    }

    public void addInterface(String interfaceName) {
        this.interfaces.add(interfaceName);
    }

    public void addField(SdoField field) {
        this.fields.add(field);
    }

    public List<SdoField> getFields() {
        return this.fields;
    }

    public void addMethod(SdoMethod method) {
        this.methods.add(method);
    }

    public List<SdoMethod> getMethods() {
        return this.methods;
    }

    public void addConstructor(SdoConstructor method) {
        this.constructors.add(method);
    }

    public List<SdoConstructor> getConstructors() {
        return this.constructors;
    }

    public void addNestedClass(SdoNestedClass sdoNestedClass) {
        if (!this.nestedClasses.contains(sdoNestedClass)) {
            this.nestedClasses.add(sdoNestedClass);
        }
    }

    public List<SdoNestedClass> getNestedClasses() {
        return this.nestedClasses;
    }

    @Override
    public String getPureCode() {
        return this.getCode(true, true);
    }

    protected String getCode(boolean pure, boolean withPackageName) {
        StringBuilder builder = new StringBuilder();
        if (withPackageName && this.packageName != null && this.packageName.length() > 0) {
            builder.append("package ").append(this.packageName).append(";\n\n");
        }
        builder.append(super.getCode(pure));
        builder.append("class ").append(this.className);
        if (this.superclass != null && this.superclass.length() > 0) {
            builder.append(" extends ").append(this.superclass);
        }
        if (this.interfaces != null && this.interfaces.size() > 0) {
            builder.append(" implements ");
            for (String interf : this.interfaces) {
                builder.append(interf).append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("\n{\n");
        SdoClass.allign(builder, "   ", this.toStringNestedClasses());
        SdoClass.allign(builder, "   ", this.toStringFields());
        builder.append("\n");
        SdoClass.allign(builder, "   ", this.toStringConstructors());
        builder.append("\n");
        SdoClass.allign(builder, "   ", this.toStringMethods());
        builder.append("}\n");
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.getCode(false, true);
    }

    public String toStringNestedClasses() {
        StringBuffer builder = new StringBuffer();
        for (SdoNestedClass nestedClass : this.nestedClasses) {
            builder.append(nestedClass.toString()).append("\n\n");
        }
        return builder.toString();
    }

    public String toStringFields() {
        StringBuffer builder = new StringBuffer();
        for (SdoField field : this.fields) {
            builder.append(field.toString()).append("\n\n");
        }
        return builder.toString();
    }

    public String toStringConstructors() {
        StringBuffer builder = new StringBuffer();
        for (SdoConstructor constructor : this.constructors) {
            builder.append(constructor.toString()).append("\n").append("\n");
        }
        return builder.toString();
    }

    public String toStringMethods() {
        StringBuffer builder = new StringBuffer();
        for (SdoMethod method : this.methods) {
            builder.append(method.toString()).append("\n").append("\n");
        }
        return builder.toString();
    }

    public static void allign(StringBuilder builder, String indention, String value) {
        BufferedReader reader = new BufferedReader(new StringReader(value));
        try {
            String temp;
            while ((temp = reader.readLine()) != null) {
                if (temp.length() > 0) {
                    builder.append(indention);
                }
                builder.append(temp).append('\n');
            }
        }
        catch (Exception error) {
            Trace.logError(SdoClass.class, error.getMessage());
        }
    }
}

