/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.generator;

import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.mf.operation.edl.generator.CompilerException;
import com.streamscape.runtime.mf.operation.edl.generator.SdoAnnotation;
import com.streamscape.runtime.mf.operation.edl.generator.SdoClass;
import com.streamscape.runtime.mf.operation.edl.generator.SdoCompiler;
import com.streamscape.runtime.mf.operation.edl.generator.SdoConstructor;
import com.streamscape.runtime.mf.operation.edl.generator.SdoField;
import com.streamscape.runtime.mf.operation.edl.generator.SdoMethod;
import com.streamscape.runtime.mf.operation.edl.generator.SdoNestedClass;
import java.io.IOException;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class JavassistSdoCompiler
implements SdoCompiler {
    private ClassPool classPool;
    private ClassLoader classLoader;

    public JavassistSdoCompiler(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classPool = new ClassPool(true);
        this.classPool.appendClassPath(new LoaderClassPath(classLoader));
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public synchronized void removeClass(SdoClass sdoClass) {
        CtClass clazz;
        if (!(sdoClass instanceof SdoNestedClass) && (clazz = this.classPool.getOrNull(sdoClass.getFullClassName())) != null) {
            clazz.defrost();
            clazz.detach();
            CtClass ctClass = this.classPool.makeClass(sdoClass.getFullClassName());
        }
    }

    @Override
    public synchronized byte[] compile(SdoClass sdoClass) throws CompilerException {
        try {
            CtClass clazz;
            ConstPool constPool = null;
            if (sdoClass instanceof SdoNestedClass) {
                clazz = this.classPool.getOrNull(((SdoNestedClass)sdoClass).getParentClass().getFullClassName());
                if (clazz == null) {
                    clazz = this.classPool.makeClass(((SdoNestedClass)sdoClass).getParentClass().getFullClassName());
                }
                clazz = clazz.makeNestedClass(sdoClass.getClassName(), true);
            } else {
                clazz = this.classPool.getOrNull(sdoClass.getFullClassName());
                if (clazz == null) {
                    clazz = this.classPool.makeClass(sdoClass.getFullClassName());
                }
            }
            clazz.setModifiers(1);
            ClassFile classFile = clazz.getClassFile();
            classFile.setVersionToJava5();
            constPool = classFile.getConstPool();
            if (sdoClass.getSuperclass() != null && sdoClass.getSuperclass().length() > 0) {
                clazz.setSuperclass(this.classPool.getCtClass(sdoClass.getSuperclass()));
            }
            if (sdoClass.getInterfaces() != null && sdoClass.getInterfaces().size() > 0) {
                CtClass[] ctInterfaces = new CtClass[sdoClass.getInterfaces().size()];
                int i = 0;
                for (String interf : sdoClass.getInterfaces()) {
                    ctInterfaces[i++] = this.classPool.getCtClass(interf);
                }
                clazz.setInterfaces(ctInterfaces);
            }
            for (SdoField field : sdoClass.getFields()) {
                CtField ctField = CtField.make(field.getPureCode(), clazz);
                clazz.addField(ctField);
                if (field.getAnnotations() == null || field.getAnnotations().size() <= 0) continue;
                ctField.getFieldInfo().addAttribute(this.makeAnnotations(constPool, field.getAnnotations()));
            }
            for (SdoConstructor constructor : sdoClass.getConstructors()) {
                CtConstructor ctconstructor = new CtConstructor(new CtClass[0], clazz);
                ctconstructor.setBody(constructor.getBody());
                clazz.addConstructor(ctconstructor);
            }
            for (SdoMethod method : sdoClass.getMethods()) {
                clazz.addMethod(CtNewMethod.make(method.getPureCode(), clazz));
            }
            if (sdoClass.getAnnotations() != null && sdoClass.getAnnotations().size() > 0) {
                clazz.getClassFile().addAttribute(this.makeAnnotations(constPool, sdoClass.getAnnotations()));
            }
            byte[] bytes = clazz.toBytecode();
            return bytes;
        }
        catch (NotFoundException exception) {
            throw new CompilerException("Compilation error, file not found: " + exception.getMessage());
        }
        catch (CannotCompileException exception) {
            throw new CompilerException("Compilation error, cannot compile: " + exception.getMessage());
        }
        catch (IOException exception) {
            throw new CompilerException("Compilation error, io exception: " + exception.getMessage());
        }
    }

    protected AnnotationsAttribute makeAnnotations(ConstPool constPool, List<SdoAnnotation> sdoAnnotations) {
        AnnotationsAttribute attribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        for (SdoAnnotation sdoAnnotation : sdoAnnotations) {
            Annotation annotation = new Annotation(sdoAnnotation.getType(), constPool);
            for (Pair entry : sdoAnnotation.getValues()) {
                if (entry.second instanceof String) {
                    annotation.addMemberValue((String)entry.first, (MemberValue)new StringMemberValue((String)entry.second, constPool));
                    continue;
                }
                if (entry.second instanceof Integer) {
                    annotation.addMemberValue((String)entry.first, (MemberValue)new IntegerMemberValue(constPool, (Integer)entry.second));
                    continue;
                }
                if (!(entry.second instanceof List)) continue;
                ArrayMemberValue arrayMemberValue = new ArrayMemberValue(constPool);
                MemberValue[] values = new StringMemberValue[((List)entry.second).size()];
                int i = 0;
                for (String value : (List)entry.second) {
                    values[i++] = new StringMemberValue(value, constPool);
                }
                arrayMemberValue.setValue(values);
                annotation.addMemberValue((String)entry.first, (MemberValue)arrayMemberValue);
            }
            attribute.addAnnotation(annotation);
        }
        return attribute;
    }
}

