/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.generator;

import com.streamscape.Trace;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPath;
import javassist.NotFoundException;

public class JavassistMemoryClassPath
implements ClassPath {
    public Map<String, byte[]> referencedClasses = new HashMap<String, byte[]>();

    public void addReferencedClassToLoader(String classname, byte[] bytes) {
        this.referencedClasses.put(classname, bytes);
    }

    public Map<String, byte[]> getReferencedClasses() {
        return this.referencedClasses;
    }

    @Override
    public InputStream openClassfile(String classname) throws NotFoundException {
        if (this.referencedClasses.containsKey(classname)) {
            return new ByteArrayInputStream(this.referencedClasses.get(classname));
        }
        return null;
    }

    @Override
    public URL find(String classname) {
        if (this.referencedClasses.containsKey(classname)) {
            try {
                String cname = classname.replace('.', '/') + ".class";
                return new URL("file:/JavassistMemoryClassPath/" + cname);
            }
            catch (MalformedURLException exception) {
                Trace.logException(this, exception, false);
            }
        }
        return null;
    }

    public void close() {
    }
}

