/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.generator;

import com.streamscape.runtime.mf.operation.edl.DataField;
import com.streamscape.runtime.mf.operation.edl.EDLException;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.runtime.mf.operation.edl.generator.CompilerException;
import com.streamscape.runtime.mf.operation.edl.generator.SdoClass;
import com.streamscape.runtime.mf.operation.edl.generator.SdoCompiler;
import com.streamscape.runtime.mf.operation.edl.generator.SdoConstructor;
import com.streamscape.runtime.mf.operation.edl.generator.SdoField;
import com.streamscape.runtime.mf.operation.edl.generator.SdoMethod;
import com.streamscape.runtime.mf.operation.edl.generator.SdoNestedClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractSdoGenerator {
    private SdoClass sdoClass;
    private SdoConstructor sdoConstructor;
    protected SdoCompiler sdoCompiler;
    private Map<String, byte[]> compiledClasses;
    private List<GeneratorObserver> observers = null;

    public AbstractSdoGenerator(SdoCompiler compiler, String packageName, String className) {
        this.sdoCompiler = compiler;
        this.sdoClass = new SdoClass(packageName, className);
    }

    public void addObserver(GeneratorObserver observer) {
        if (this.observers == null) {
            this.observers = new ArrayList<GeneratorObserver>();
        }
        this.observers.add(observer);
        observer.onCreateClass(this.sdoClass);
    }

    public SdoConstructor getSdoConstructor() {
        if (this.sdoConstructor == null) {
            this.sdoConstructor = new SdoConstructor(this.sdoClass);
            this.sdoClass.addConstructor(this.sdoConstructor);
            if (this.observers != null) {
                for (GeneratorObserver observer : this.observers) {
                    observer.onCreateConstructor(this.sdoConstructor);
                }
            }
        }
        return this.sdoConstructor;
    }

    protected void addField(SdoField sdoField) {
        this.addField(sdoField, null);
    }

    protected void addField(SdoField sdoField, DataField dataField) {
        this.compiledClasses = null;
        this.sdoClass.addField(sdoField);
        if (this.observers != null) {
            for (GeneratorObserver observer : this.observers) {
                observer.onAddField(sdoField, dataField);
            }
        }
    }

    protected void addMethod(SdoMethod method) {
        this.compiledClasses = null;
        this.sdoClass.addMethod(method);
        if (this.observers != null) {
            for (GeneratorObserver observer : this.observers) {
                observer.onAddMethod(method);
            }
        }
    }

    protected void addNestedClass(SdoNestedClass sdoNestedClass) {
        this.compiledClasses = null;
        this.sdoClass.addNestedClass(sdoNestedClass);
    }

    public static String getSetterForField(String name) {
        return "set" + AbstractSdoGenerator.methodSuffixForField(name);
    }

    public static String getGetterForField(String name) {
        return "get" + AbstractSdoGenerator.methodSuffixForField(name);
    }

    public static String methodSuffixForField(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public SdoClass getSdoClass() {
        return this.sdoClass;
    }

    public String getSourceCode() {
        return this.sdoClass.toString();
    }

    public void compile() throws EDLException {
        try {
            if (this.compiledClasses == null) {
                this.sdoCompiler.removeClass(this.sdoClass);
                this.compiledClasses = new HashMap<String, byte[]>();
                for (SdoNestedClass nestedClass : this.sdoClass.getNestedClasses()) {
                    this.compiledClasses.put(SdoUtils.getNestedClassPathInJar(nestedClass.getParentClass().getFullClassName(), nestedClass.getClassName()), this.sdoCompiler.compile(nestedClass));
                }
                this.compiledClasses.put(SdoUtils.getClassPathInJar(this.sdoClass.getFullClassName()), this.sdoCompiler.compile(this.sdoClass));
            }
        }
        catch (CompilerException exception) {
            throw new EDLException(exception.getMessage());
        }
    }

    public Map<String, byte[]> getByteCode() throws EDLException {
        if (this.compiledClasses == null) {
            this.compile();
        }
        return this.compiledClasses;
    }

    public Map<String, byte[]> getByteCodeWithClassNames() throws EDLException {
        if (this.compiledClasses == null) {
            this.compile();
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : this.compiledClasses.entrySet()) {
            result.put(SdoUtils.convertClassPathInJarToFullClassName(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public String getSourceCodePathInJar() {
        return SdoUtils.getSrcPathInJar(SdoUtils.makeFullClassName(this.sdoClass.getPackageName(), this.sdoClass.getClassName()));
    }

    public static interface GeneratorObserver {
        public void onCreateClass(SdoClass var1);

        public void onCreateConstructor(SdoConstructor var1);

        public void onAddField(SdoField var1, DataField var2);

        public void onAddMethod(SdoMethod var1);
    }
}

