/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.doc;

import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.runtime.mf.operation.edl.doc.AbstractSdoFieldsHtmlTable;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDoc;
import com.streamscape.sef.network.http.server.html.PropertiesHtmlTable;
import com.streamscape.sef.network.http.server.html.SemanticTypeHtml;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;

public class SdoHtmlDoc {
    public static String SDO_DOC_AND_FIELDS_TABLE_START = "<!-- SDO DOC AND FIELDS TABLE START -->";
    public static String SDO_DOC_AND_FIELDS_TABLE_END = "<!-- SDO DOC AND FIELDS TABLE END -->";
    private String packageName;
    private String className;
    private String alias;
    private String archiveName;
    private JavaDoc javaDoc;
    private AbstractSdoFieldsHtmlTable fieldsTable;

    public SdoHtmlDoc(AbstractSdoFieldsHtmlTable fieldsTable) {
        this.fieldsTable = fieldsTable;
    }

    public String getHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append(SorServletCss.header(this.className)).append("\n");
        PropertiesHtmlTable properties = new PropertiesHtmlTable();
        properties.addIfNotNull("Namespace", this.packageName);
        properties.addIfNotNull("Object Class", this.className);
        properties.addIfNotNull("Alias", this.alias);
        properties.addIfNotNull("User Class", true);
        properties.addIfNotNull("Archive", this.archiveName);
        builder.append(properties.getHtml());
        builder.append(SDO_DOC_AND_FIELDS_TABLE_START);
        builder.append(SemanticTypeHtml.getDocumentationHeader()).append("\n");
        if (this.javaDoc != null) {
            builder.append(SorServletCss.makeJavaDocHtml(this.javaDoc, null, null));
        }
        builder.append(SemanticTypeHtml.getDataObjectHeader());
        if (this.fieldsTable != null) {
            builder.append("\n").append(this.fieldsTable.getHtml()).append("\n");
        }
        builder.append(SDO_DOC_AND_FIELDS_TABLE_END);
        return builder.toString();
    }

    public String getFullHtml() {
        return SorServletCss.makeFullHtmlWithPlaceHolders(this.className, this.getHtml());
    }

    public String getHtmlPathInJar() {
        return SdoUtils.getHtmlPathInJar(SdoUtils.makeFullClassName(this.packageName, this.className));
    }

    public static String getDocumentationBlock(String html) {
        int start = html.indexOf(SDO_DOC_AND_FIELDS_TABLE_START);
        int end = html.indexOf(SDO_DOC_AND_FIELDS_TABLE_END);
        if (start != -1 && end != -1) {
            return html.substring(start, end + SDO_DOC_AND_FIELDS_TABLE_END.length());
        }
        return null;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setNamespace(String namespace) {
        this.packageName = namespace;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public void setDocumentation(JavaDoc javaDoc) {
        this.javaDoc = javaDoc;
    }

    public AbstractSdoFieldsHtmlTable getFieldsTable() {
        return this.fieldsTable;
    }
}

