/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl.doc;

import com.streamscape.Trace;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.DataField;
import com.streamscape.runtime.mf.operation.edl.EnumDataField;
import com.streamscape.runtime.mf.operation.edl.ListDataField;
import com.streamscape.runtime.mf.operation.edl.MapDataField;
import com.streamscape.runtime.mf.operation.edl.SimpleDataField;
import com.streamscape.runtime.mf.operation.edl.doc.AbstractSdoFieldsHtmlTable;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.network.http.server.html.AbstractToken;
import com.streamscape.sef.network.http.server.html.ComplexToken;
import com.streamscape.sef.network.http.server.html.ExtendedRowMetaData;
import com.streamscape.sef.network.http.server.html.SemanticTypeHtml;
import com.streamscape.sef.network.http.server.html.SemanticTypeLink;
import com.streamscape.sef.network.http.server.html.TextToken;
import com.streamscape.sef.network.http.server.html.Token;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SdoFieldsHtmlTable
extends AbstractSdoFieldsHtmlTable {
    private static String COLUMN_ELEMENT = "Element";
    private static String COLUMN_TYPE = "Type";
    private static String COLUMN_DEFAULT_VALUE = "Default Value";
    private static String COLUMN_NOT_NULL = "Not null";
    private static String COLUMN_LENGTH = "Length";
    private static String COLUMN_RANGE = "Range";
    private static String COLUMN_DOMAIN = "Domain";
    private static String COLUMN_MATCHES = "Matches";
    private static String COLUMN_ENUM = "Enum";
    private static String COLUMN_OFFSET = "Offset";
    private static String COLUMN_DESCRIPTION = "Description";

    public SdoFieldsHtmlTable() {
        ExtendedRowMetaData meta = new ExtendedRowMetaData();
        meta.addColumn(COLUMN_ELEMENT, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DEFAULT_VALUE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_TYPE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_NOT_NULL, ExtendedRowMetaData.Align.CENTER);
        meta.addColumn(COLUMN_LENGTH, ExtendedRowMetaData.Align.RIGHT);
        meta.addColumn(COLUMN_RANGE, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DOMAIN, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_MATCHES, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_ENUM, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_OFFSET, ExtendedRowMetaData.Align.LEFT);
        meta.addColumn(COLUMN_DESCRIPTION, ExtendedRowMetaData.Align.LEFT);
        this.table = new RowSet(meta);
    }

    @Override
    public void addField(DataField dataField) {
        try {
            ArrayList<Object> values;
            Row row = this.table.newRow();
            row.setColumn(COLUMN_ELEMENT, (Object)dataField.getName());
            row.setColumn(COLUMN_NOT_NULL, (Object)dataField.isNotNull());
            row.setColumn(COLUMN_LENGTH, (Object)dataField.getLength());
            row.setColumn(COLUMN_MATCHES, (Object)dataField.getRegexp());
            row.setColumn(COLUMN_DESCRIPTION, (Object)dataField.getDescription());
            if (dataField.getDomainName() != null) {
                row.setColumn(COLUMN_DOMAIN, (Object)dataField.getDomainName());
            } else if (dataField.getDomainValues() != null) {
                values = new ArrayList<Object>();
                for (String string : dataField.getDomainValues()) {
                    values.add(dataField.getType().escapeValue(string));
                }
                row.setColumn(COLUMN_DOMAIN, values);
            }
            if (dataField.getRangeName() != null) {
                row.setColumn(COLUMN_RANGE, (Object)dataField.getRangeName());
            } else if (dataField.getRangeValues() != null) {
                values = new ArrayList();
                for (Map.Entry entry : dataField.getRangeValues()) {
                    values.add(dataField.getType().escapeValue(entry.getKey()) + " - " + dataField.getType().escapeValue(entry.getValue()));
                }
                row.setColumn(COLUMN_RANGE, values);
            }
            if (dataField.getEnumName() != null) {
                row.setColumn(COLUMN_ENUM, (Object)new SemanticTypeLink(dataField.getEnumName()));
            }
            if (dataField.getBeginOffset() != null) {
                row.setColumn(COLUMN_OFFSET, (Object)(dataField.getBeginOffset() + "-" + dataField.getEndOffset()));
            }
            if (dataField instanceof SimpleDataField) {
                row.setColumn(COLUMN_TYPE, (Object)this.getTypeToken(dataField));
                row.setColumn(COLUMN_DEFAULT_VALUE, (Object)dataField.getType().escapeValue(((SimpleDataField)dataField).getDefaultValue()));
            } else if (dataField instanceof EnumDataField) {
                row.setColumn(COLUMN_TYPE, (Object)this.getTypeToken(dataField));
                row.setColumn(COLUMN_DEFAULT_VALUE, (Object)dataField.getType().escapeValue(((EnumDataField)dataField).getDefaultValue()));
            } else if (dataField instanceof ListDataField) {
                row.setColumn(COLUMN_TYPE, (Object)this.getTypeToken(dataField));
                ListDataField listDataField = (ListDataField)dataField;
                if (listDataField.getDefaultValues() != null && listDataField.getDefaultValues().size() > 0) {
                    ArrayList<String> values2 = new ArrayList<String>();
                    for (String value : listDataField.getDefaultValues()) {
                        values2.add(listDataField.getType().escapeValue(value));
                    }
                    row.setColumn(COLUMN_DEFAULT_VALUE, values2);
                } else if (listDataField.isArray()) {
                    row.setColumn(COLUMN_DEFAULT_VALUE, (Object)"Null filled array");
                } else {
                    row.setColumn(COLUMN_DEFAULT_VALUE, (Object)"Empty List");
                }
            } else if (dataField instanceof MapDataField) {
                row.setColumn(COLUMN_TYPE, (Object)this.getTypeToken(dataField));
                row.setColumn(COLUMN_DEFAULT_VALUE, (Object)"Empty Map");
            }
            this.table.addToRowSet(row);
        }
        catch (RowException exception) {
            Trace.logException(this, exception, false);
        }
        catch (SQLException exception) {
            Trace.logException(this, exception, false);
        }
    }

    protected Token getTypeToken(DataField dataField, com.streamscape.sef.evtrigger.function.types.Type<?> fieldType) {
        if (fieldType instanceof AbstractObjectType) {
            return new SemanticTypeLink(((AbstractObjectType)fieldType).getSemanticTypeName());
        }
        Object typeToken = fieldType.getName();
        if (dataField != null && dataField.getPrecision() != null) {
            typeToken = (String)typeToken + "(" + dataField.getPrecision();
            if (dataField.getScale() != null) {
                typeToken = (String)typeToken + "," + dataField.getScale();
            }
            typeToken = (String)typeToken + ")";
        }
        return new TextToken(typeToken);
    }

    protected Token getTypeToken(DataField dataField) {
        if (dataField instanceof ListDataField) {
            ListDataField listDataField = (ListDataField)dataField;
            if (listDataField.isArray()) {
                return new ComplexToken().append(this.getTypeToken(listDataField.getElementDataField())).append("[]");
            }
            ComplexToken fieldType = new ComplexToken().append("list(").append(this.getTypeToken(listDataField.getElementDataField()));
            if (listDataField.getEntryTypeName() != null && listDataField.getEntryTypeName().length() > 0) {
                fieldType.append(" alias ").append(listDataField.getEntryTypeName());
            }
            if (listDataField.isImplicit()) {
                fieldType.append(", ").append("xml-implicit-collection");
            }
            if (listDataField.isSuppressGenericType()) {
                fieldType.append(", ").append("json-suppress-generic-type");
            }
            fieldType.append(")");
            return fieldType;
        }
        if (dataField instanceof MapDataField) {
            MapDataField mapDataField = (MapDataField)dataField;
            ComplexToken token = mapDataField.getEntryTypeName() == null ? new ComplexToken().append("map(").append(this.getTypeToken(null, mapDataField.getType())).append(",").append(this.getTypeToken(mapDataField.getValueField())) : new ComplexToken().append("map(").append(new SemanticTypeLink(mapDataField.getEntryTypeName())).append("(").append(this.getTypeToken(null, mapDataField.getType())).append(" ").append(mapDataField.getKeyName()).append(",").append(this.getTypeToken(mapDataField.getValueField())).append(" ").append(mapDataField.getValueName()).append(")");
            if (mapDataField.isImplicit()) {
                token.append(", ").append("xml-implicit-collection");
            }
            if (mapDataField.isSuppressGenericType()) {
                token.append(", ").append("json-suppress-generic-type");
            }
            token.append(")");
            return token;
        }
        return this.getTypeToken(dataField, dataField.getType());
    }

    public void addField(String name, Type type) {
        Row row = this.table.newRow();
        try {
            row.setColumn(COLUMN_ELEMENT, (Object)name);
            row.setColumn(COLUMN_TYPE, (Object)this.getTypeToken(type));
            this.table.addToRowSet(row);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    private Token getTypeToken(Type type) {
        ParameterizedType parameterizedType;
        AbstractToken typeToken = new TextToken(type.toString());
        if (type instanceof Class) {
            SemanticType semanticType;
            Class clazz = (Class)type;
            typeToken = clazz.isArray() ? new ComplexToken().append(this.getTypeToken(clazz.getComponentType())).append("[]") : (clazz.isPrimitive() ? new TextToken(clazz.getSimpleName()) : ((semanticType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticClass(clazz.getName())) != null ? new SemanticTypeLink(semanticType.getTypeName()) : new ComplexToken().append(clazz.getName()).append(" ").append(new SemanticTypeHtml.SemanticTypePreviewLink(clazz.getName(), "xml", "xml")).append(" ").append(new SemanticTypeHtml.SemanticTypePreviewLink(clazz.getName(), "json", "json"))));
        } else if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            Class clazz = (Class)parameterizedType.getRawType();
            if (List.class.isAssignableFrom(clazz)) {
                typeToken = new ComplexToken().append("list(").append(this.getTypeToken(parameterizedType.getActualTypeArguments()[0])).append(")");
            } else if (Map.class.isAssignableFrom(clazz)) {
                typeToken = new ComplexToken().append("map(").append(this.getTypeToken(parameterizedType.getActualTypeArguments()[0])).append(", ").append(this.getTypeToken(parameterizedType.getActualTypeArguments()[1])).append(")");
            }
        }
        return typeToken;
    }
}

