/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.lib.loader.MemoryJarFile;

public class SdoUtils {
    public static String makeFullClassName(String packageName, String className) {
        if (packageName == null || packageName.length() == 0) {
            return className;
        }
        return packageName + "." + className;
    }

    public static String makeArchiveName(String archiveName) {
        if (archiveName == null) {
            return null;
        }
        if (!((String)archiveName).endsWith(".jar")) {
            archiveName = (String)archiveName + ".jar";
        }
        return archiveName;
    }

    public static String makeSimplePackageName(String packageName) {
        if (packageName.endsWith(".pkg")) {
            packageName = packageName.substring(0, packageName.length() - 4);
        }
        return packageName;
    }

    public static String getClassPathInJar(String fullClassName) {
        return MemoryJarFile.convertClassNameToPathInJar(fullClassName) + ".class";
    }

    public static String getNestedClassPathInJar(String parentFullClassName, String nestedClassName) {
        return MemoryJarFile.convertClassNameToPathInJar(parentFullClassName) + "$" + nestedClassName + ".class";
    }

    public static String convertClassPathInJarToFullClassName(String pathInJar) {
        if ((pathInJar = pathInJar.replaceAll("/", ".")).endsWith(".class")) {
            pathInJar = pathInJar.substring(0, pathInJar.length() - 6);
        }
        return pathInJar;
    }

    public static String getSrcPathInJar(String fullClassName) {
        return MemoryJarFile.convertClassNameToPathInJar(fullClassName) + ".java";
    }

    public static String getValidatorClassPathInJar(String fullClassName) {
        return MemoryJarFile.convertClassNameToPathInJar(SdoUtils.getValidatorClassName(fullClassName)) + ".class";
    }

    public static String getValidatorSrcPathInJar(String fullClassName) {
        return MemoryJarFile.convertClassNameToPathInJar(SdoUtils.getValidatorClassName(fullClassName)) + ".java";
    }

    public static String getValidatorClassName(String fullClassName) {
        return SdoUtils.makeSubpath(fullClassName, "validator");
    }

    public static String getValidatorPackageName(String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        if (!((String)packageName).isEmpty()) {
            packageName = (String)packageName + ".";
        }
        return (String)packageName + "validator";
    }

    public static String getEDLPathInJar(String fullClassName) {
        return MemoryJarFile.convertClassNameToPathInJar(SdoUtils.makeSubpath(fullClassName, "edl")) + ".edl";
    }

    public static String getHtmlPathInJar(String fullClassName) {
        return MemoryJarFile.convertClassNameToPathInJar(SdoUtils.makeSubpath(fullClassName, "html")) + ".html";
    }

    public static String makeSubpath(String fullClassName, String subpath) {
        String packageName = "";
        String className = fullClassName;
        int pos = fullClassName.lastIndexOf(46);
        if (pos != -1) {
            packageName = fullClassName.substring(0, pos);
            className = fullClassName.substring(pos + 1);
        }
        return SdoUtils.makeSubpath(packageName, className, subpath);
    }

    public static String makeSubpath(String packageName, String className, String subpath) {
        if (packageName == null) {
            packageName = "";
        } else if (!((String)packageName).isEmpty()) {
            packageName = (String)packageName + ".";
        }
        packageName = (String)packageName + subpath + ".";
        return (String)packageName + className;
    }

    public static String getPackageName(String fullClassName) {
        int pos = fullClassName.lastIndexOf(46);
        if (pos != -1) {
            return fullClassName.substring(0, pos);
        }
        return "";
    }
}

