/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.lib.loader.MemoryJarFile;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.AbstractSdoOperation;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Action;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Predicate;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;
import java.util.Set;

public class DropSdoOperation
extends AbstractSdoOperation {
    public static final String NAME = "drop sdo";

    public DropSdoOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setDescription("Drops SDO with specified name.");
        this.syntax.setExamples("drop sdo Employee\ndrop sdo Employee clean\ndrop sdo Employee force\ndrop sdo Employee ns com.employee\ndrop sdo Employee ns com.employee archive employee.jar\ndrop sdo Employee archive employee.jar clean\n");
        this.syntax.addCompletionCommand("list types");
    }

    @Override
    protected void fillDSLSyntax() {
        this.syntax.setAction(new Action("DROP")).setPredicate(new Predicate("TYPE").addPossibleValue("SDO"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier().addParameter(new IdentifierParameter("ObjectName"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("IF EXISTS").setName("ifexists")).setRequired(false));
        this.syntax.addModifier(DropSdoOperation.createNamespaceModifier());
        this.syntax.addModifier(DropSdoOperation.createArchiveModifier());
        this.syntax.addModifier(new Modifier("CLEAN", false));
        this.syntax.addModifier(new Modifier("FORCE", false));
        this.syntax.addModifier(DropSdoOperation.createNoValidateModifier());
    }

    @Override
    protected String createSyntaxDescription() {
        return "ObjectName specifies semantic type name. Semantic type defines SDO class name. SDO class name is searched in lib/archives.\nIf the archive is found then SDO class removed from that archive. Also SDO validator class and source code are removed.\nIf the archive contains no more classes then archive is removed from the repository and from package containing this archive.\nOperation automatically unloads and loads packages containing archive with dropped SDO.\n\nParameters:\n\n      <ObjectName>          - Name of semantic type or SDO class if namespace is specified.\n      if exists             - Drops SDO only if its semantic type exists.\n      ns <namespace>        - Java package where SDO class is located.\n      archive <ArchiveName> - Archive where SDO class is located.\n      clean                 - Removes the package from Runtime Package Manifest if it does not contain more archives and drops it.\n      force                 - Drops the associated semantic type without checking for dependencies (e.g. event prototypes).\n      no validate           - Indicates not to validate package-dependent entities (semantic types and prototypes).\n      with wait             - Executes this operation in synchronous mode (waits until completion).";
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getSemanticTypeCache().listUserSemanticTypes());
    }

    @Override
    protected SLResponse doInvoke(AbstractSdoOperation.Definition definition, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        Object fullClassName;
        DSLStatement statement = definition.statement;
        String objectName = statement.getParameter("ObjectName").getValue();
        String archiveName = statement.getParameter("ArchiveName").getValue();
        boolean ifexists = statement.getModifier("ifexists").isPresent();
        SemanticType semanticType = null;
        if (statement.existsParameter("namespace")) {
            fullClassName = statement.getParameter("namespace").getValue() + "." + objectName;
        } else {
            objectName = this.resolveTypeName(objectName);
            semanticType = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(objectName);
            if (semanticType == null) {
                if (ifexists) {
                    feedbackInvoker.addFeedback("\n");
                    feedbackInvoker.addWarning("Semantic type '" + objectName + "' does not exist.");
                    return new SLResponse();
                }
                throw new Exception("Semantic type '" + objectName + "' does not exist. If this is an orphaned type, use a fully qualified namespace to drop.");
            }
            if (semanticType.isSystem()) {
                throw new Exception("System semantic type '" + objectName + "' cannot be removed.");
            }
            fullClassName = semanticType.getClassName();
        }
        archiveName = this.lookupArchiveWithClass(archiveName, semanticType, (String)fullClassName, ifexists);
        if (archiveName == null && ifexists) {
            feedbackInvoker.addFeedback("\n");
            feedbackInvoker.addWarning("Archive '" + archiveName + "' does not contain specified SDO class '" + (String)fullClassName + "'.");
            return new SLResponse();
        }
        this.removeSemanticType(semanticType, definition.statement, feedbackInvoker);
        Set<String> unloadedPackages = this.unloadPackagesWithArchive(archiveName, DropSdoOperation.isNoValidate(statement), feedbackInvoker, "\n");
        MemoryJarFile jarFile = new MemoryJarFile(((RuntimeContext)this.callable).getRepositoryAccessor().getArchive(archiveName));
        this.removeSdoNestedClasses(jarFile, (String)fullClassName, feedbackInvoker);
        jarFile.removeEntry(SdoUtils.getSrcPathInJar((String)fullClassName));
        jarFile.removeEntry(SdoUtils.getClassPathInJar((String)fullClassName));
        jarFile.removeEntry(SdoUtils.getEDLPathInJar((String)fullClassName));
        jarFile.removeEntry(SdoUtils.getHtmlPathInJar((String)fullClassName));
        jarFile.removeEntry(SdoUtils.getValidatorSrcPathInJar((String)fullClassName));
        jarFile.removeEntry(SdoUtils.getValidatorClassPathInJar((String)fullClassName));
        boolean showWarningOnClean = false;
        Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackageByArchive(archiveName);
        if (jarFile.listEntries().size() == 0) {
            ((RuntimeContext)this.callable).getRepositoryAccessor().removeArchive(archiveName);
            feedbackInvoker.addFeedback("Archive '" + archiveName + "' removed.\n");
            if (pkg != null) {
                pkg.removeJAR(archiveName);
                if (statement.existsModifier("CLEAN")) {
                    if (pkg.listJARs().isEmpty()) {
                        if (((RuntimeContext)this.callable).getPackageManifestManager().existsPackage(pkg.getFullName())) {
                            ((RuntimeContext)this.callable).getPackageManifestManager().removePackage(pkg.getFullName());
                            feedbackInvoker.addFeedback("Package '" + pkg.getFullName() + "' unregistered in Runtime Package Manifest.\n");
                        }
                        ((RuntimeContext)this.callable).getRepositoryAccessor().removePackage(pkg.getType(), pkg.getName(), false);
                        feedbackInvoker.addFeedback("Package '" + pkg.getFullName() + "' removed.\n");
                    } else {
                        showWarningOnClean = true;
                    }
                } else {
                    this.updatePackage(pkg, feedbackInvoker);
                }
            }
        } else {
            if (statement.existsModifier("CLEAN")) {
                showWarningOnClean = true;
            }
            ((RuntimeContext)this.callable).getRepositoryAccessor().removeArchive(archiveName);
            ((RuntimeContext)this.callable).getRepositoryAccessor().addArchive(archiveName, jarFile.getJarBytes());
            feedbackInvoker.addFeedback("Archive '" + archiveName + "' recreated.\n");
            this.updatePackage(pkg, feedbackInvoker);
        }
        this.loadPackages(unloadedPackages, DropSdoOperation.isNoValidate(statement), feedbackInvoker, "");
        if (showWarningOnClean) {
            feedbackInvoker.addFeedback("\n");
            feedbackInvoker.addWarning("Package and associated archives were not removed because active object references exist.\n");
        }
        return new SLResponse();
    }

    private void removeSemanticType(SemanticType semanticType, DSLStatement statement, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        if (semanticType != null) {
            try {
                feedbackInvoker.addLongFeedback("Removing semantic type '" + semanticType.getTypeName() + "'...");
                TypeFactory.removeSemanticType(semanticType.getTypeName(), statement.existsModifier("FORCE"));
                feedbackInvoker.completeLongFeedback();
            }
            catch (SemanticTypeFactoryException exception) {
                throw new Exception("Removing semantic type '" + semanticType.getTypeName() + "' failed.", exception);
            }
        }
    }

    private void updatePackage(Package pkg, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        if (pkg != null) {
            this.updatePackageObject(pkg);
            feedbackInvoker.addFeedback("Package '" + pkg.getFullName() + "' updated.\n");
        }
    }
}

