/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.omf.xsd.EdlGenerator;
import com.streamscape.omf.xsd.JsonParser;
import com.streamscape.omf.xsd.Parser;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoFromXsdXmlOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractSdoOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.HashMap;
import java.util.Map;

public class CreateSdoFromJsonOperation
extends AbstractCreateSdoFromXsdXmlOperation {
    public static final String NAME = "create sdo from json";

    public CreateSdoFromJsonOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setDescription("Creates EDL statements for SDO objects based on provided JSON file. For more info see JsonParser javadoc.");
        this.syntax.setExamples("create sdo from json file 'C:\\test.json'\nsave @ 'c:\\output.edl'\nbuild\ntypes('//Employee/age' int, '//Employee/name' string)\nnamespace sample.namespace\nreplace archive sample.jar\nreplace package sample");
    }

    @Override
    protected void fillDSLSyntax() {
        this.syntax.setAction("CREATE SDO FROM").setSubject(new Subject("JSON"));
        CreateSdoFromJsonOperation.appendFileModifier(this.syntax);
        CreateSdoFromJsonOperation.appendAsArrayModifier(this.syntax);
        CreateSdoFromJsonOperation.appendSaveBuildModifier(this.syntax);
        CreateSdoFromJsonOperation.appendSimpleTypeAsStringModifier(this.syntax);
        CreateSdoFromJsonOperation.appendWithDefaultsModifier(this.syntax);
        CreateSdoFromJsonOperation.appendTypesModifier(this.syntax);
        CreateSdoFromJsonOperation.appendAliasesModifier(this.syntax);
        AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.addAfterBodyModifiers(this.syntax);
    }

    @Override
    protected String createSyntaxDescription() {
        return "Parameters:\n" + CreateSdoFromJsonOperation.getFileModifierDescription("JSON") + CreateSdoFromJsonOperation.appendAsArrayModifierDescription() + CreateSdoFromJsonOperation.getSaveBuildModifierDescription() + CreateSdoFromJsonOperation.getSimpleTypeAsStringModifierDescription() + CreateSdoFromJsonOperation.getWithDefaultsModifierDescription() + CreateSdoFromJsonOperation.getTypesModifierDescription() + CreateSdoFromJsonOperation.getAliasesModifierDescription() + AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.getAfterBodyModifiersDescription();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSdoOperation.Definition(NAME, statement);
    }

    @Override
    protected Parser onCreateParser(DSLStatement statement) {
        return new JsonParser();
    }

    public static void appendAsArrayModifier(DSLStatementSyntax syntax) {
        syntax.addModifier(((CompoundModifier)new CompoundModifier("AsCompound").setRequired(false)).addModifier((AbstractModifier)new Modifier("AS").addParameter((SyntaxParameter)new IdentifierParameter("Wrapper Type Name").setName("WrapperTypeName"))).addModifier((AbstractModifier)((Modifier)new Modifier("ARRAY OF").addParameter((SyntaxParameter)new IdentifierParameter("Array Element Type Name").setName("WrapperArrayElementTypeName"))).setRequired(false)).addModifier((AbstractModifier)((Modifier)new Modifier("ENTRIES NAME").addParameter((SyntaxParameter)new IdentifierParameter("Entries Field Name").setName("WrappedArrayEntriesName"))).setRequired(false)));
    }

    public static String appendAsArrayModifierDescription() {
        return "   as <type>                     - Type name of wrapper element, that same as root type '//'.\n                                   For root array means wrapper type name.\n   array of <type>               - Element type name for root arrays and entries field name.\n   entries name <field name>     - Entries field name.\n";
    }

    @Override
    protected void onUpdateGenerator(DSLStatement statement, EdlGenerator generator) {
        String wrapperTypeName = statement.getParameter("WrapperTypeName").getValue(null);
        String entriesName = statement.getParameter("WrappedArrayEntriesName").getValue(null);
        String arrayElementTypeName = statement.getParameter("WrapperArrayElementTypeName").getValue(null);
        if (wrapperTypeName != null) {
            Map<String, String> typesMap = generator.getTypesMap();
            if (typesMap == null) {
                typesMap = new HashMap<String, String>();
            }
            if (entriesName != null) {
                typesMap.put("//", wrapperTypeName + "/" + entriesName);
            } else {
                typesMap.put("//", wrapperTypeName);
            }
            if (arrayElementTypeName != null) {
                typesMap.put("//" + (entriesName != null ? entriesName : "entries"), arrayElementTypeName);
            }
            generator.setTypesMap(typesMap);
        }
    }
}

