/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.lib.file.DelimitedFileHeaderParser;
import com.streamscape.omf.xsd.Parser;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoFromXsdXmlOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractSdoOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class CreateSdoFromCsvOperation
extends AbstractCreateSdoFromXsdXmlOperation {
    public static final String NAME = "create sdo from csv";

    public CreateSdoFromCsvOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setDescription("Creates EDL statement for SDO object based on provided CSV or DELIMITED file.\nFile should contain a header line with delimited field names.\nBy default assumed that this header line placed at the first line and all fields have type string.\nFor CSV file default delimiter is comma(,) and default quote is double quotes(\").\nFor delimited files delimiter should be set manually.");
        this.syntax.setExamples("create sdo from csv file 'C:\\test.csv'\nsave @ 'c:\\output.edl'\nbuild\ntypes('//price' int)\nnamespace sample.namespace\nreplace archive sample.jar\nreplace package sample\n\ncreate sdo from delimited file 'C:\\test.txt'\nsave @ 'c:\\output.edl'\nbuild\nheader at line 2\ndelimiter ';'\ntypes('//price' int)\nnamespace sample.namespace\nreplace archive sample.jar\nreplace package sample");
    }

    private static void appendSdoNameModifier(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)new Modifier("SDO NAME").addParameter((SyntaxParameter)new IdentifierParameter("name").setName("SdoName")));
    }

    public static void appendHeaderAtLineDelimiterModifier(DSLStatementSyntax syntax, boolean withHeaderAtLine) {
        if (withHeaderAtLine) {
            syntax.addModifier((AbstractModifier)((Modifier)new Modifier("HEADER AT LINE").addParameter((SyntaxParameter)new IntegerParameter("line number").setName("headerAtLine"))).setRequired(false));
        }
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DELIMITER").addParameter(new StringParameter("delimiter"))).setRequired(false));
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("QUOTE").addParameter(new StringParameter("quoteSymbol"))).setRequired(false));
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("QUOTE ESCAPE").addParameter(new StringParameter("quoteEscapeSymbol"))).setRequired(false));
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("IGNORE INNER QUOTES").setName("ignoreInnerQuotes")).setRequired(false));
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("NOT IGNORE INNER QUOTES").setName("notIgnoreInnerQuotes")).setRequired(false));
    }

    private static String getSdoNameModifierDescription() {
        return "   sdo name <name>               - Name of result SDO.\n";
    }

    public static String getHeaderAtLineDelimiterModifierDescription(boolean withHeaderAtLine) {
        Object result = "";
        if (withHeaderAtLine) {
            result = "   header at line <line number>  - Header line number. Default 1.\n";
        }
        result = (String)result + "   lines delimiter '<delimiter>' - Delimiter between lines.\n   delimiter '<delimiter>'       - Delimiter between field names.\n   quote '<quote symbol>'        - Quote symbol.\n   quote scape '<quote symbol>'  - Quote escape symbol, use empty value to unset.\n   ignore inner quotes           - Ignore inner quotes in lines like \" first value with \"inner quotes\"\",\"seconds value\".\n";
        return result;
    }

    @Override
    protected void fillDSLSyntax() {
        this.syntax.setAction("CREATE SDO FROM").setPredicate((ChoiceModifier)new ChoiceModifier().addPossibleValues("CSV", "DELIMITED").setIncludeToDefinition(true));
        CreateSdoFromCsvOperation.appendFileModifier(this.syntax);
        CreateSdoFromCsvOperation.appendSaveBuildModifier(this.syntax);
        CreateSdoFromCsvOperation.appendSdoNameModifier(this.syntax);
        CreateSdoFromCsvOperation.appendHeaderAtLineDelimiterModifier(this.syntax, true);
        CreateSdoFromCsvOperation.appendTypesModifier(this.syntax);
        CreateSdoFromCsvOperation.appendAliasesModifier(this.syntax);
        AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.addAfterBodyModifiers(this.syntax);
    }

    @Override
    protected String createSyntaxDescription() {
        return "Parameters:\n\n" + CreateSdoFromCsvOperation.getFileModifierDescription("CSV") + CreateSdoFromCsvOperation.getSaveBuildModifierDescription() + CreateSdoFromCsvOperation.getSdoNameModifierDescription() + CreateSdoFromCsvOperation.getHeaderAtLineDelimiterModifierDescription(true) + CreateSdoFromCsvOperation.getTypesModifierDescription() + CreateSdoFromCsvOperation.getAliasesModifierDescription() + AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.getAfterBodyModifiersDescription();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractSdoOperation.Definition(NAME, statement);
    }

    public static DelimitedFileParameters parseDelimitedFileParameters(DSLStatement statement, boolean alter) throws Exception {
        DelimitedFileParameters parameters = new DelimitedFileParameters();
        boolean isCsv = statement.getModifier("CSV").isPresent();
        if (isCsv && !alter) {
            parameters.delimiter = ",";
            parameters.quoteSymbol = Character.valueOf('\"');
            parameters.quoteEscapeSymbol = Character.valueOf('\"');
            parameters.ignoreInnerQuotes = false;
        }
        if (statement.getParameter("delimiter").isPresent()) {
            parameters.delimiter = statement.getParameter("delimiter").getValue();
            if (parameters.delimiter.length() == 0) {
                throw new Exception("Delimiter should be not empty.");
            }
        } else if (!isCsv && !alter) {
            throw new Exception("Delimiter should be set for delimited file.");
        }
        if (statement.getParameter("quoteSymbol").isPresent()) {
            String quote = statement.getParameter("quoteSymbol").getValue();
            if (isCsv && !quote.equals("\"")) {
                throw new Exception("Quote symbol cannot be changed for CSV file descriptor.");
            }
            if (quote.length() == 0) {
                parameters.quoteSymbol = Character.valueOf('\u0000');
            } else if (quote.length() == 1) {
                parameters.quoteSymbol = Character.valueOf(quote.charAt(0));
            } else {
                throw new Exception("Quote should be empty or consist of one symbol.");
            }
        }
        if (statement.getParameter("quoteEscapeSymbol").isPresent()) {
            String quoteEscape = statement.getParameter("quoteEscapeSymbol").getValue();
            if (isCsv && !quoteEscape.equals("") && !quoteEscape.equals("\"")) {
                throw new Exception("Quote escape symbol cannot be changed for CSV file descriptor. Can be only \" or unset.");
            }
            if (quoteEscape.length() == 0) {
                parameters.quoteEscapeSymbol = Character.valueOf('\u0000');
            } else if (quoteEscape.length() == 1) {
                parameters.quoteEscapeSymbol = Character.valueOf(quoteEscape.charAt(0));
            } else {
                throw new Exception("Quote escape should consist of one symbol.");
            }
        }
        if (statement.getModifier("ignoreInnerQuotes").isPresent()) {
            parameters.ignoreInnerQuotes = true;
        }
        if (statement.getModifier("notIgnoreInnerQuotes").isPresent()) {
            parameters.ignoreInnerQuotes = false;
        }
        if (statement.getParameter("headerAtLine").isPresent()) {
            parameters.headerLineNumber = Integer.valueOf(statement.getParameter("headerAtLine").getValue());
        }
        return parameters;
    }

    @Override
    protected Parser onCreateParser(DSLStatement statement) throws Exception {
        DelimitedFileParameters parameters = CreateSdoFromCsvOperation.parseDelimitedFileParameters(statement, false);
        DelimitedFileHeaderParser parser = new DelimitedFileHeaderParser();
        parser.setSdoName(statement.getParameter("SdoName").getValue());
        parser.setDelimiter(parameters.delimiter);
        parser.setQuoteSymbol(parameters.quoteSymbol != null ? parameters.quoteSymbol.charValue() : (char)'\u0000');
        parser.setQuoteEscapeSymbol(parameters.quoteEscapeSymbol != null ? parameters.quoteEscapeSymbol.charValue() : (char)'\u0000');
        parser.setHeaderLineNumber(parameters.headerLineNumber);
        return parser;
    }

    public static class DelimitedFileParameters {
        public int headerLineNumber = 1;
        public String delimiter = ",";
        public Character quoteSymbol = null;
        public Character quoteEscapeSymbol = null;
        public Boolean ignoreInnerQuotes = null;
    }
}

