/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.runtime.mf.operation.edl.AbstractAlterSdoOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoOperation;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Action;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Predicate;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class AlterSdoEnumOperation
extends AbstractAlterSdoOperation {
    public static final String NAME = "alter sdo enum";

    public AlterSdoEnumOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setDescription("Alters the specified SDO Enum object class and its source code.\nOperation automatically unloads and loads packages containing archive with altered SDO.");
        this.syntax.setExamples(AlterSdoEnumOperation.getSdoEnumExamples());
    }

    @Override
    protected void fillDSLSyntax() {
        this.syntax.setAction(new Action("ALTER")).setPredicate(new Predicate("SDO ENUMERATION").addPossibleValues("SDO ENUM", "ENUM OBJECT", "ENUMERATION OBJECT", "ENUM"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier().addParameter(new IdentifierParameter("ObjectName"))).setSyntaxHint(SyntaxHint.SPACE));
        AlterSdoEnumOperation.addSdoEnumBodyParameter(this.syntax);
        this.addCommonAfterBodyModifiers(this.syntax);
    }

    @Override
    protected String createSyntaxDescription() {
        return "Parameters:\n   <ObjectName>                - Name of semantic type or SDO Enum class if namespace is specified.\n" + this.getCommonAfterBodyModifiersDescription() + "\n\n" + AlterSdoEnumOperation.getJavaDocDescription() + "\n\n" + AlterSdoEnumOperation.getSdoEnumBodySyntaxDescription();
    }

    @Override
    protected void onGenerateSdoAndWriteToJarFile(String fullClassName, String alias, DSLStatement statement, AbstractCreateSdoOperation.CreateSdoAfterBodyParameters params, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        this.generateSdoEnumAndWriteToJarFile(fullClassName, statement, params, feedbackInvoker);
    }
}

