/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.loader.MemoryJarFile;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoOperation;
import com.streamscape.runtime.mf.operation.edl.CreateSdoEnumOperation;
import com.streamscape.runtime.mf.operation.edl.CreateSdoOperation;
import com.streamscape.runtime.mf.operation.edl.DataField;
import com.streamscape.runtime.mf.operation.edl.SdoBodyCompleter;
import com.streamscape.runtime.mf.operation.edl.SdoEnumBodyCompleter;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.runtime.mf.operation.edl.doc.SdoDocGeneratorObserver;
import com.streamscape.runtime.mf.operation.edl.doc.SdoEnumFieldsHtmlTable;
import com.streamscape.runtime.mf.operation.edl.doc.SdoFieldsHtmlTable;
import com.streamscape.runtime.mf.operation.edl.doc.SdoHtmlDoc;
import com.streamscape.runtime.mf.operation.edl.generator.JavassistSdoCompiler;
import com.streamscape.runtime.mf.operation.edl.generator.SdoGenerator;
import com.streamscape.runtime.mf.operation.edl.generator.SdoValidatorGenerator;
import com.streamscape.runtime.mf.operation.edl.parser.SdoBodyParser;
import com.streamscape.runtime.mf.operation.edl.parser.SdoEnumBodyParser;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.service.mf.impl.AlterEventTriggerOperationImpl;
import com.streamscape.sef.utils.SemanticTypeInfo;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.AbstractStatementValueList;
import com.streamscape.tools.lexer.BufferUtils;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.parser.ParserException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSdoOperation
extends AbstractOperation<RuntimeContext> {
    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.fillDSLSyntax();
        this.syntax.addModifier(new Modifier("WITH WAIT", false));
        this.syntax.setSyntaxDescription(this.createSyntaxDescription());
        this.syntax.addTag(OperationTag.edl);
    }

    protected abstract void fillDSLSyntax();

    protected abstract String createSyntaxDescription();

    protected static CompoundModifier createNamespaceModifier() {
        CompoundModifier namespace = (CompoundModifier)new CompoundModifier("compoundassembly").setRequired(false);
        namespace.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("namespacemodifier").addModifier(new Modifier("NAMESPACE"))).addModifier(new Modifier("NS")));
        namespace.addParameter((AbstractParameter)new IdentifierParameter("Class Name space such as a Package or Assembly").setName("namespace"));
        return namespace;
    }

    protected static Modifier createArchiveModifier() {
        Modifier archive = (Modifier)new Modifier("ARCHIVE").setRequired(false);
        archive.addParameter((SyntaxParameter)new IdentifierParameter("ArchiveName").setName("ArchiveName"));
        return archive;
    }

    protected static Modifier createAncestorModifier() {
        return (Modifier)((Modifier)new Modifier("ANCESTOR").setRequired(false)).addParameter((SyntaxParameter)new IdentifierParameter("AncestorSemanticType").setName("AncestorSemanticType"));
    }

    protected static CompoundModifier createIsInterfaceModifier() {
        return ((CompoundModifier)new CompoundModifier("isinterfacecompound").setRequired(false)).addModifier(new Modifier("INTERFACE")).addModifier(new ChoiceModifier("ISINTERFACE").addPossibleValue("TRUE").addPossibleValue("FALSE"));
    }

    protected static Modifier createDescriptionModifier() {
        return (Modifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("description"))).setRequired(false);
    }

    protected static Modifier createNoSourceModifier() {
        return (Modifier)((Modifier)new Modifier("NO SOURCE").setName("nosource")).setRequired(false);
    }

    protected static Modifier createNoTypeModifier() {
        return (Modifier)((Modifier)new Modifier("NO TYPE").setName("notype")).setRequired(false);
    }

    protected static Modifier createNoDocModifier() {
        return (Modifier)((Modifier)new Modifier("NO DOC").setName("nodoc")).setRequired(false);
    }

    protected static Modifier createNoValidateModifier() {
        return new Modifier("NO VALIDATE", false);
    }

    protected static Modifier createNoGlobalModifier() {
        return new Modifier("NO GLOBAL", false);
    }

    protected static boolean isNoValidate(DSLStatement statement) {
        return statement.existsModifier("NO VALIDATE");
    }

    protected static void addObjectNameAndAliasParameter(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier().addParameter(new IdentifierParameter("ObjectName"))).setSyntaxHintSpace());
        syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("ALIAS").addParameter(new IdentifierParameter("AliasName"))).setRequired(false)).setSyntaxHintSpace());
    }

    protected static void addSdoBodyParameter(DSLStatementSyntax syntax) {
        syntax.addModifier(new Modifier("AS"));
        ExpressionParameter sdoParameter = ((ExpressionParameter)new ExpressionParameter("SDO body fields, semicolon delimited", '{', '}').setName("SdoBody")).setIgnoreQuotes(false).setSkipOneLineComments(true);
        sdoParameter.setCompleter(new SdoBodyCompleter());
        sdoParameter.setCompactSyntax("{\n" + AbstractSdoOperation.getSdoBodySyntax() + "}");
        syntax.addParameter(sdoParameter);
    }

    protected static void addSdoEnumBodyParameter(DSLStatementSyntax syntax) {
        syntax.addModifier(new Modifier("AS"));
        ExpressionParameter sdoParameter = ((ExpressionParameter)new ExpressionParameter("SDO enum fields, semicolon delimited", '{', '}').setName("SdoBody")).setIgnoreQuotes(false).setSkipOneLineComments(true);
        sdoParameter.setCompleter(new SdoEnumBodyCompleter());
        sdoParameter.setCompactSyntax("{\n" + AbstractSdoOperation.getSdoEnumBodySyntax() + "}");
        syntax.addParameter(sdoParameter);
    }

    protected static String getJavaDocDescription() {
        return "Javadoc can be defined anywhere in command, preferable at the beginning and should be enclosed in /** and */.\nJavadoc extends standard html tags with the following tags:\n\n   Links:\n      {@link type#<typename>}                                               - Link to semantic type with specified name.\n      {@link prototype#<eventId>}                                           - Link to event prototype with specified eventId.\n      {@link service#<ServiceType>.<ServiceName>}                           - Link to service with specified type and name.\n      {@link handler#<ServiceType>.<ServiceName>.<HandlerName>}             - Link to service event handler with specified type and name.\n      {@link collection#[<DataspaceType>].<DataspaceName>.<CollectionName>} - Link to collection in specified dataspace. Default dataspace type is TSPACE.\n      {@link function#[<DataspaceType>].<DataspaceName>.<FunctionName>}     - Link to function in specified dataspace. Default dataspace type is TSPACE.\n\n   Code tag:\n      {@code <some code>} - Formats specified code with specific font.\n\n   Tags, in order they will be in result html:\n      @author <authors>              - Authors in javadoc style.\n      @version <version>             - Version in javadoc style.\n      @copyright <copyright>         - Copyright in javadoc style.\n      @since <since version or date> - Since in javadoc style.\n      @see <link>                    - See also in javadoc style.\n      @anytag <any text>             - Any tag.\n      @raises <events>               - Raises events.\n      @todo <what todo>              - Todo.\n\n    NOTE: Tags should be located at the end of javadoc. One tag ends where another tag starts.\n";
    }

    protected static String getAliasDescription() {
        return "   alias <AliasName>           - Top name of serialized object.\n";
    }

    protected static String getSdoBodySyntax() {
        return "   <data type> <element name> [= <default value>] [not null] [length]\n      [[value] in domain {<Domain Name> | (<value1>,... )}]\n      [[value] in range {<Range Name> | (<low_value> <high_value>,... )}]\n      [[value] matches ('<Regular Expression>)']\n      [[value] in enum <Enum Name>]\n      [alias '<alias>'\n      [description '<Description>'];...;\n";
    }

    protected static String getSdoBodySyntaxDescription() {
        return "SDO body syntax:\n\n" + AbstractSdoOperation.getSdoBodySyntax() + "\nElement types:\n\n   byte[(precision)]\n   char\n   short\n   int[(precision)]\n   long[(precision)]\n   float[(precision, scale)]\n   double[(precision,scale)]\n   decimal[(precision,scale)]\n   bigint[(precision)]\n   boolean\n   string\n   date - should be in format 'yyyy-MM-dd HH:mm:ss'\n   object\n   event\n   SqlDate - should be in format 'yyyyy-MM-dd'\n   SqlTimestamp - should be in format 'yyyy-MM-dd hh:mm:ss[.f...]'\n   <some type>[size]\n   any registered in runtime semantic type\n   list(<some type> [ alias <XmlEntryTypeName>] [, xml-implicit-collection])\n   map(<some simple type>, <some type>)\n   map(<MapEntryTypeName>(<key type> [<keyName>], <value type> [<valueName>])\n\nElement/types parameters:\n\n   [(xml-attribute)]                                    - Tells serializer to process this field as XML attribute of parent SDO.\n                                                          Applicable for simple types only.\n   [, xml-implicit-collection]                          - Tells XML serializer to process collection as implicit.\n                                                          For example to suppress parent class name.\n                                                          For example if we have implicit field myList in object MyObject then it will be serialized  like this:\n                                                          <MyObject>\n                                                             <MyTypeEntry>\n                                                                 <field1></field1>\n                                                                 <field2></field2>\n                                                             </MyTypeEntry>\n                                                          </MyObject>\n   [ alias <XmlEntryTypeName> ]                         - Tells XML serializer the name of XML tag for collection entry.\n                                                          <mylist>\n                                                             <MyTypeEntry>\n                                                                 <field1></field1>\n                                                                 <field2></field2>\n                                                             </MyTypeEntry>\n                                                          </mylist>\n   <MapEntryTypeName>                                   - Specifies internal entry type name for implicit maps, not displayed in serialization or analyzer\n                                                          By default MAP in JSON is serialized like this\n                                                            {\n                                                              \"key1\" : \"value1\",\n                                                              \"key2\" : \"value2\"\n                                                            }\n                                                          Value can be any other type or complex object, string is used to minimize sample.\n                                                          If we specify MapEntryTypeName it will look like\n                                                            [\n                                                              {\n                                                                \"key\" : \"key1\",\n                                                                \"value\" : \"value2\"\n                                                              },\n                                                              {\n                                                                \"key\" : \"key2\",\n                                                                \"value\" : \"value2\"\n                                                              }\n                                                            ]\n                                                          To change key and value field names <keyName> and <valueName> should be specified\n                                                            [\n                                                              {\n                                                                \"mykey\" : \"key1\",\n                                                                \"myvalue\" : \"value2\"\n                                                              },\n                                                              {\n                                                                \"mykey\" : \"key2\",\n                                                                \"myvalue\" : \"value2\"\n                                                              }\n                                                            ]\n   not null                                             - Specifies that value should be not null.\n   length <length>                                      - Maximum field length. Applicable for list, map and string types only.\n   [value] in enum <Enum Name>                          - Specifies that value should be in enum values.\n                                                          Applicable for STRING types only.\n   alias '<alias>'                                      - Field alias used for deserialization.\n   description '<Description>'                          - Field description, will be in SDO html doc.\n   [value] matches (<Regular Expression>)               - Regular expression for field value. Applicable only for system types\n                                                          except map, Row, RowSet, RowArray, object and event.\n   [value] in domain {<Domain Name> | (<value1>,... )}  - Domain for field values, named or values collection.\n                                                          Applicable for all types except semantic type.\n   [value] in range {<Range Name> | (<low> <high>,...)} - Range for field values, named or values collection.\n                                                          Applicable for all types except semantic type.\n";
    }

    protected static String getCreateSdoExamples() {
        return "set delimiter ##\n\n/**\n*  <p>Employee gender.<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com}\n*/\ncreate sdo enum Gender\nas\n{\n  MALE description 'man';\n  FEMALE description 'woman';\n}\nnamespace com.employee\nreplace archive employee\nreplace package employee\ndescription 'Employee gender'\n##\n\n/**\n*  <p>Employee position.<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com}\n*/\ncreate sdo enum Position\nas\n{\n  ENGINEER description 'Engineer';\n  MANAGER  description 'Manager';\n}\nnamespace com.employee\nreplace archive employee\nreplace package employee\ndescription 'Employee position'\n##\n\n/**\n*  <p>Employee object<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com}\n*/\ncreate sdo Employee\nas\n{\n  string firstname = 'first name' not null description 'Employee first name';\n  string lastname  = 'last name';\n  Gender gender = Gender.MALE not null;\n  string position = 'ENGINEER' in enum Position;\n  int    age = 20 in range (20 45);\n  SqlDate hiredate = '2013-01-01';\n}\nnamespace com.employee\nreplace archive employee\nreplace package employee\ndescription 'Employee object'\n##\n\n/**\n*  <p>List of <code>{@link Employee}</code> objects<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com} {@link Employee}\n*/\ncreate sdo Employees\nas\n{\nlist(Employee) employees not null description 'Employee list';\n}\nnamespace com.employee\nreplace archive employee\nreplace package employee\ndescription 'Employees object'\n##\n\ncreate sdo MetaTags\nas\n{\n  map(mtag(string myKey, string myValue)) mtags description 'Meta tags map.';\n}\nnamespace com.employee\nreplace archive employee\nreplace package employee\ndescription 'Meta tags.'\n##\n\nset delimiter\n";
    }

    protected static String getAlterSdoExamples() {
        return "set delimiter ##\n\n/**\n*  <p>Employee gender. Altered.<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com}\n*/\nalter sdo enum Gender\nas\n{\n  MALE description 'Man';\n  FEMALE description 'Woman';\n}\ndescription 'Employee gender, altered'\n##\n\n/**\n*  <p>Employee position. Altered.<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com}\n*/\nalter sdo enum Position\nas\n{\n  ENGINEER description 'Engineer';\n  MANAGER  description 'Manager';\n  ADMIN    description 'Admin';\n}\ndescription 'Employee position, altered'\n##\n\n/**\n*  <p>Employee object. Altered<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com}\n*/\nalter sdo Employee\nas\n{\n  string firstname = 'first name' not null description 'Employee first name';\n  string lastname  = 'last name';\n  Gender gender = Gender.MALE not null;\n  string position = 'ENGINEER' in enum Position;\n  int    age = 30 in range (20 45);\n  SqlDate hiredate = '2013-01-01';\n}\ndescription 'Employee, altered'\n##\n\nset delimiter\n";
    }

    protected static String getSdoEnumBodySyntax() {
        return "  <Value> [description '<description>'];...;\n";
    }

    protected static String getSdoEnumBodySyntaxDescription() {
        return "SDO enum body syntax:\n\n  <Value> [description '<description>'];...;\n\n";
    }

    protected static String getSdoEnumExamples() {
        return "set delimiter ##\n\n/**\n*  <p>Content type enum.<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com}\n*/\ncreate sdo enum ContentType\nas\n{\n  HTML description 'Html page';\n  TEXT description 'Plain text';\n  JPEG description 'Jpeg image';\n}\nnamespace com.attachment\nreplace archive attachment\nreplace package attachment\ndescription 'ContentType enum'\n##\n\n/**\n*  <p>Attachment object<p>\n*  @author Nik\n*  @version 1.1\n*  @see {@link www.streamscape.com}\n*/\ncreate sdo Attachment\nas\n{\nContentType cType = ContentType.HTML not null description 'attachment type';\n}\nnamespace com.attachment\nreplace archive attachment\nreplace package attachment\ndescription 'Attachment object'\n##\n\nset delimiter\n";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getName(), statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.statement.existsModifier("WITH WAIT")) {
            try (AbstractDSLOperation.AsyncFeedbackInvoker feedbackInvoker = new AbstractDSLOperation.AsyncFeedbackInvoker(session);){
                SLResponse sLResponse = this.doInvoke(definition, feedbackInvoker);
                return sLResponse;
            }
        }
        FabricThreadManager.getInstance().createThread("FSYS:SLANG.SdoOperation", "Performs some operation with SDO.", () -> {
            Utils.sleep(500L);
            try (AbstractDSLOperation.AsyncFeedbackInvoker feedbackInvoker = new AbstractDSLOperation.AsyncFeedbackInvoker(session);){
                this.doInvoke(definition, feedbackInvoker);
                this.raiseSLMessage(null, session);
            }
            catch (Throwable exception) {
                this.processError(exception, session);
            }
        }).start();
        return new PseudoSLResponse();
    }

    protected abstract SLResponse doInvoke(Definition var1, AbstractDSLOperation.FeedbackInvoker var2) throws Exception;

    protected void processError(Throwable exception, MFSession session) {
        try {
            this.raiseSLMessageError(Utils.formatException(exception, "\n       "), session);
            this.raiseSLMessage(null, session);
        }
        catch (Throwable error) {
            Trace.logException(this, exception, true);
            Trace.logException(this, error, true);
        }
    }

    protected boolean generateSdoAndWriteToJarFile(String fullClassName, String alias, DSLStatement statement, AbstractCreateSdoOperation.CreateSdoAfterBodyParameters params, AbstractDSLOperation.FeedbackInvoker feedbackInvoker, boolean isChoice) throws Exception {
        feedbackInvoker.addLongFeedback("\nGenerating SDO...");
        JavassistSdoCompiler compiler = new JavassistSdoCompiler(((RuntimeContext)this.callable).getSystemClassLoaderChain());
        SdoGenerator sdoGenerator = SdoGenerator.create(compiler, fullClassName, BufferUtils.extractUnwrappedJavaDoc(statement.getOriginalStatement()));
        SdoValidatorGenerator sdoValidatorGenerator = SdoValidatorGenerator.create(compiler, fullClassName);
        sdoGenerator.getSdoClass().setSuperclass(CloneableDataObject.class.getName());
        sdoGenerator.setAlias(alias);
        if (isChoice) {
            sdoGenerator.addChoiceAnnotation();
            sdoValidatorGenerator.setIsChoice(isChoice);
        }
        SdoDocGeneratorObserver sdoDocGenerator = new SdoDocGeneratorObserver(new SdoFieldsHtmlTable());
        sdoGenerator.addObserver(sdoDocGenerator);
        SdoBodyParser parser = new SdoBodyParser();
        String body = statement.getParameter("SdoBody").getValue().trim();
        try {
            for (DataField dataField : parser.parse("{\n" + body + "\n}")) {
                sdoGenerator.addField(dataField);
                sdoValidatorGenerator.addField(dataField);
            }
        }
        catch (ParserException exception) {
            int position = BufferUtils.getAbsolutePosition(body, exception.getLineNumber() - 1, exception.getPositionInLine() > 0 ? exception.getPositionInLine() - 1 : 0);
            BufferUtils.setLineAndPositions(exception, statement.getOriginalStatement(), position += statement.getOriginalStatement().indexOf(body, BufferUtils.skipSpacesAndCommends(statement.getOriginalStatement(), 0)));
            throw exception;
        }
        sdoGenerator.finish();
        sdoValidatorGenerator.finish();
        feedbackInvoker.completeLongFeedback();
        sdoValidatorGenerator.validate(sdoGenerator.getByteCodeWithClassNames(), feedbackInvoker);
        return this.writeSdoJarFile(statement, params, sdoGenerator, sdoValidatorGenerator, sdoDocGenerator.getSdoDoc(), feedbackInvoker);
    }

    protected boolean generateSdoEnumAndWriteToJarFile(String fullClassName, DSLStatement statement, AbstractCreateSdoOperation.CreateSdoAfterBodyParameters params, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        JavassistSdoCompiler compiler = new JavassistSdoCompiler(((RuntimeContext)this.callable).getSystemClassLoaderChain());
        SdoGenerator sdoGenerator = SdoGenerator.create(compiler, fullClassName, BufferUtils.extractUnwrappedJavaDoc(statement.getOriginalStatement()));
        sdoGenerator.addEnumAnnotation();
        SdoDocGeneratorObserver sdoDocGenerator = new SdoDocGeneratorObserver(new SdoEnumFieldsHtmlTable());
        sdoGenerator.addObserver(sdoDocGenerator);
        SdoEnumBodyParser parser = new SdoEnumBodyParser();
        for (DataField dataField : parser.parse("{" + statement.getParameter("SdoBody").getValue() + "}")) {
            sdoGenerator.addField(dataField);
        }
        sdoGenerator.finish();
        sdoGenerator.compile();
        if (feedbackInvoker != null) {
            feedbackInvoker.addFeedback("SDO Enum object created.\n");
        }
        return this.writeSdoJarFile(statement, params, sdoGenerator, null, sdoDocGenerator.getSdoDoc(), feedbackInvoker);
    }

    protected Set<String> unloadPackagesWithArchive(String archiveName, boolean noValidate, AbstractDSLOperation.FeedbackInvoker feedbackInvoker, String indent) throws Exception {
        HashSet<String> packages = new HashSet<String>();
        if (((RuntimeContext)this.callable).getRepositoryAccessor().existsArchive(archiveName)) {
            for (String loadedPackageName : ((RuntimeContext)this.callable).getPackageManifestManager().listLoadedPackages()) {
                PackageDescriptor descriptor = ((RuntimeContext)this.callable).getPackageManifestManager().getPackage(loadedPackageName);
                Package loadedPackage = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(descriptor.getPackageType(), descriptor.getPackageName());
                if (loadedPackage == null || !loadedPackage.containsJAR(archiveName)) continue;
                ((RuntimeContext)this.callable).getPackageManifestManager().unloadPackage(loadedPackageName, !noValidate);
                feedbackInvoker.addFeedback(indent + "Package '" + descriptor.getFullName() + "' unloaded.\n");
                packages.add(loadedPackageName);
            }
        }
        return packages;
    }

    protected void loadPackages(Set<String> packages, boolean noValidate, AbstractDSLOperation.FeedbackInvoker feedbackInvoker, String indent) throws Exception {
        for (String packageName : packages) {
            if (!((RuntimeContext)this.callable).getPackageManifestManager().existsPackage(packageName) || ((RuntimeContext)this.callable).getPackageManifestManager().isPackageLoaded(packageName)) continue;
            ((RuntimeContext)this.callable).getPackageManifestManager().loadPackage(packageName, !noValidate);
            feedbackInvoker.addFeedback(indent + "Package '" + packageName + "' loaded.\n");
        }
    }

    protected boolean writeSdoJarFile(DSLStatement statement, AbstractCreateSdoOperation.CreateSdoAfterBodyParameters params, SdoGenerator sdoGenerator, SdoValidatorGenerator sdoValidatorGenerator, SdoHtmlDoc sdoDoc, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        feedbackInvoker.addFeedback("\nSaving SDO...\n");
        Set<String> unloadedPackages = this.unloadPackagesWithArchive(params.archiveName, params.create || params.noValidate, feedbackInvoker, "  ");
        MemoryJarFile jarFile = ((RuntimeContext)this.callable).getRepositoryAccessor().existsArchive(params.archiveName) ? new MemoryJarFile(((RuntimeContext)this.callable).getRepositoryAccessor().getArchive(params.archiveName)) : new MemoryJarFile();
        this.removeSdoNestedClasses(jarFile, sdoGenerator.getSdoClass().getFullClassName(), feedbackInvoker);
        jarFile.updateEntries(sdoGenerator.getByteCode());
        if (sdoValidatorGenerator != null) {
            jarFile.updateEntries(sdoValidatorGenerator.getByteCode());
        }
        if (!params.noSource) {
            jarFile.updateEntry(sdoGenerator.getSourceCodePathInJar(), sdoGenerator.getSourceCode().getBytes());
            if (sdoValidatorGenerator != null) {
                jarFile.updateEntry(sdoValidatorGenerator.getSourceCodePathInJar(), sdoValidatorGenerator.getSourceCode().getBytes());
            }
        } else {
            jarFile.removeEntry(sdoGenerator.getSourceCodePathInJar());
            if (sdoValidatorGenerator != null) {
                jarFile.removeEntry(sdoValidatorGenerator.getSourceCodePathInJar());
            }
        }
        if (!params.noDoc) {
            sdoDoc.setArchiveName(params.archiveName);
            jarFile.updateEntry(sdoDoc.getHtmlPathInJar(), sdoDoc.getFullHtml().getBytes());
        } else {
            jarFile.removeEntry(sdoDoc.getHtmlPathInJar());
        }
        String edlScript = this.getEdlScript(statement, jarFile, sdoGenerator.getSdoClass().getFullClassName(), params.archiveName, unloadedPackages);
        jarFile.updateEntry(SdoUtils.getEDLPathInJar(sdoGenerator.getSdoClass().getFullClassName()), edlScript.getBytes());
        if (((RuntimeContext)this.callable).getRepositoryAccessor().existsArchive(params.archiveName)) {
            ((RuntimeContext)this.callable).getRepositoryAccessor().removeArchive(params.archiveName);
            feedbackInvoker.addFeedback("  Archive '" + params.archiveName + "' removed.\n");
        }
        ((RuntimeContext)this.callable).getRepositoryAccessor().addArchive(params.archiveName, jarFile.getJarBytes());
        feedbackInvoker.addFeedback("  Archive '" + params.archiveName + "' added.\n");
        boolean packageUpdated = false;
        if (!unloadedPackages.isEmpty()) {
            String pkgFullName = unloadedPackages.iterator().next();
            Pair<PackageType, String> tokens = Package.parseFullName(unloadedPackages.iterator().next());
            if (((RuntimeContext)this.callable).getRepositoryAccessor().existsPackage((PackageType)((Object)tokens.first), (String)tokens.second)) {
                Package pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage((PackageType)((Object)tokens.first), (String)tokens.second);
                this.updatePackageObject(pkg);
                feedbackInvoker.addFeedback("  Package '" + pkgFullName + "' updated.\n");
                packageUpdated = true;
            }
        }
        this.loadPackages(unloadedPackages, params.noValidate, feedbackInvoker, "  ");
        feedbackInvoker.addFeedback("SDO saved.\n\n");
        return packageUpdated;
    }

    protected void updatePackageObject(Package pkg) throws Exception {
        ((RuntimeContext)this.callable).getPackageManifestManager().updatePackage(null, pkg);
    }

    protected String getEdlScript(DSLStatement statement, MemoryJarFile jarFile, String fullClassName, String archiveName, Set<String> packages) {
        String script = AlterEventTriggerOperationImpl.replaceAlterWithCreate(statement.getOriginalStatement());
        if (script == statement.getOriginalStatement()) {
            return script;
        }
        String body = statement.getParameter("SdoBody").getValue();
        int pos = script.indexOf(body);
        if (pos != -1) {
            pos += body.length();
            while (pos < script.length() && Character.isWhitespace(script.charAt(pos))) {
                ++pos;
            }
            if (script.charAt(pos) == '}') {
                StringBuilder builder = new StringBuilder();
                builder.append(script, 0, ++pos);
                builder.append("\n");
                Object ident = "";
                while (pos < script.length() && Character.isWhitespace(script.charAt(pos))) {
                    char c;
                    if ((c = script.charAt(pos++)) != ' ' && c != '\t') {
                        ident = "";
                        continue;
                    }
                    ident = (String)ident + c;
                }
                if (pos == script.length()) {
                    ident = "";
                }
                AbstractStatementValueList originalStatement = null;
                try {
                    byte[] bytes = jarFile.getEntry(SdoUtils.getEDLPathInJar(fullClassName));
                    if (bytes != null) {
                        String originalScript = new String(bytes);
                        if ((originalScript = BufferUtils.removeComments(originalScript).trim()).length() >= "create".length() && originalScript.substring(0, 6).equalsIgnoreCase("create")) {
                            try {
                                AbstractCreateSdoOperation createOperation;
                                if (this.getName().equals("alter sdo")) {
                                    createOperation = new CreateSdoOperation();
                                } else if (this.getName().equals("alter sdo enum")) {
                                    createOperation = new CreateSdoEnumOperation();
                                } else {
                                    throw new Exception("Unknown operation '" + this.getName() + "'.");
                                }
                                originalStatement = createOperation.parseDsl(originalScript);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (IOException bytes) {
                    // empty catch block
                }
                if (originalStatement != null && originalStatement.getParameter("namespace").isPresent()) {
                    builder.append((String)ident).append("namespace ").append(originalStatement.getParameter("namespace").getValue()).append("\n");
                } else {
                    builder.append((String)ident).append("namespace ").append(SdoUtils.getPackageName(fullClassName)).append("\n");
                }
                if (originalStatement != null && originalStatement.getModifier("ADDARCHIVE").isPresent()) {
                    builder.append((String)ident).append("add");
                } else {
                    builder.append((String)ident).append("replace");
                }
                if (originalStatement != null) {
                    builder.append(" archive ").append(originalStatement.getParameter("ArchiveName")).append("\n");
                } else {
                    builder.append(" archive ").append(archiveName).append("\n");
                }
                if (originalStatement != null && originalStatement.getModifier("ADDPACKAGE").isPresent()) {
                    builder.append((String)ident).append("add");
                } else {
                    builder.append((String)ident).append("replace");
                }
                if (originalStatement != null) {
                    builder.append(" package ").append(originalStatement.getParameter("PackageName")).append("\n");
                } else {
                    builder.append(" package ").append(packages.stream().findFirst().orElse("unknownpackage")).append("\n");
                }
                try {
                    Lexer<LexerFactory.DummyTokenType> lexer = LexerFactory.createLexer(script.substring(pos));
                    if (!statement.getParameter("AncestorSemanticType").isPresent()) {
                        if (originalStatement != null && originalStatement.getParameter("AncestorSemanticType").isPresent()) {
                            builder.append((String)ident).append("ancestor ").append(originalStatement.getParameter("AncestorSemanticType").getValue()).append("\n");
                        }
                    } else {
                        int startPos = lexer.getCurrentPosition();
                        lexer.readToken();
                        lexer.readToken();
                        lexer.skipSpaces();
                        builder.append((String)ident).append(lexer.substring(startPos, lexer.getCurrentPosition()));
                    }
                    if (!statement.getModifier("ISINTERFACE").isPresent()) {
                        if (originalStatement != null && originalStatement.getModifier("ISINTERFACE").isPresent()) {
                            builder.append((String)ident).append("interface ").append(originalStatement.getModifier("ISINTERFACE").getToken().toLowerCase()).append("\n");
                        }
                    } else {
                        int startPos = lexer.getCurrentPosition();
                        lexer.readToken();
                        lexer.readToken();
                        lexer.skipSpaces();
                        builder.append((String)ident).append(lexer.substring(startPos, lexer.getCurrentPosition()));
                    }
                    if (!statement.getParameter("description").isPresent()) {
                        if (originalStatement != null && originalStatement.getParameter("description").isPresent()) {
                            builder.append((String)ident).append("description '").append(originalStatement.getParameter("description").getValue().replace("'", "\\'")).append("'\n");
                        }
                    } else {
                        int startPos = lexer.getCurrentPosition();
                        lexer.readToken();
                        lexer.readToken();
                        lexer.skipSpaces();
                        builder.append((String)ident).append(lexer.substring(startPos, lexer.getCurrentPosition()));
                    }
                    builder.append(script.substring(pos + lexer.getCurrentPosition()));
                    script = builder.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return script;
    }

    protected void updateSemanticType(String objectName, String fullClassName, AbstractCreateSdoOperation.CreateSdoAfterBodyParameters params, AbstractDSLOperation.FeedbackInvoker feedbackInvoker, boolean create) throws Exception {
        SemanticType semanticType = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(objectName);
        if (semanticType == null || create || params.ancestorPresent && semanticType.getAncestorType() != null && !semanticType.getAncestorType().equals(params.ancestor) || params.descriptionPresent && semanticType.getDescription() != null && !semanticType.getDescription().equals(params.description) || params.isInterfacePresent && semanticType.isInterface() != params.isInterface || !semanticType.getClassName().equals(fullClassName)) {
            if (semanticType != null) {
                try {
                    TypeFactory.removeSemanticType(semanticType.getTypeName(), true);
                }
                catch (Exception exception) {
                    throw new Exception("Removing semantic type '" + semanticType.getTypeName() + "' failed.", exception);
                }
                feedbackInvoker.addFeedback("Semantic type '" + semanticType.getTypeName() + "' removed.\n");
            }
            SemanticType semanticTypeNew = new SemanticType(objectName, fullClassName);
            if (semanticType != null && !create) {
                semanticTypeNew.setAncestorType(semanticType.getAncestorType());
                semanticTypeNew.setDescription(semanticType.getDescription());
                semanticTypeNew.setInterface(semanticType.isInterface());
            }
            if (create || params.isInterfacePresent) {
                semanticTypeNew.setInterface(params.isInterface);
            }
            if (create || params.ancestorPresent) {
                semanticTypeNew.setAncestorType(params.ancestor);
            }
            if (create || params.descriptionPresent) {
                semanticTypeNew.setDescription(params.description);
            }
            TypeFactory.addSemanticType(semanticTypeNew);
            feedbackInvoker.addFeedback("Semantic type '" + semanticTypeNew.getTypeName() + "' added.\n");
        }
    }

    protected void removeSdoNestedClasses(MemoryJarFile jarFile, String sdoFullClassName, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        String sdoNestedPathInJar = MemoryJarFile.convertClassNameToPathInJar(sdoFullClassName) + "$";
        for (String entry : jarFile.listEntries()) {
            if (!entry.startsWith(sdoNestedPathInJar) || !entry.endsWith(".class")) continue;
            jarFile.removeEntry(entry);
            String nestedClassName = entry.substring(sdoNestedPathInJar.length(), entry.length() - 6);
            SemanticType semanticType = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(nestedClassName);
            if (semanticType == null) continue;
            TypeFactory.removeSemanticType(semanticType.getTypeName(), true);
            feedbackInvoker.addFeedback("Semantic type '" + semanticType.getTypeName() + "' removed.\n");
        }
    }

    protected void createSemanticTypesForNestedClasses(String archiveName, String fullClassName, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        if (((RuntimeContext)this.callable).getRepositoryAccessor().existsArchive(archiveName)) {
            JarFile jarFile = SemanticUtils.getLibJarFile(archiveName, (RuntimeContext)this.callable);
            String sdoNestedPathInJar = MemoryJarFile.convertClassNameToPathInJar(fullClassName) + "$";
            for (String entry : jarFile.listEntries()) {
                if (!entry.startsWith(sdoNestedPathInJar) || !entry.endsWith(".class")) continue;
                String nestedClassFullName = entry.substring(0, entry.length() - 6).replace("/", ".");
                String nestedClassName = nestedClassFullName.substring(sdoNestedPathInJar.length());
                SemanticType semanticType = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(nestedClassName);
                if (semanticType != null && semanticType.getClassName().equals(nestedClassName)) continue;
                if (semanticType != null) {
                    TypeFactory.removeSemanticType(semanticType.getTypeName(), true);
                    feedbackInvoker.addFeedback("Semantic type '" + semanticType.getTypeName() + "' removed.\n");
                }
                semanticType = new SemanticType(nestedClassName, nestedClassFullName);
                semanticType.setInterface(false);
                semanticType.setAncestorType("Object");
                semanticType.setDescription("Map entry type.");
                TypeFactory.addSemanticType(semanticType);
                feedbackInvoker.addFeedback("Semantic type '" + semanticType.getTypeName() + "' created.\n");
            }
        }
    }

    protected String lookupArchiveWithClass(String archiveName, SemanticType type, String className, boolean ifexists) throws Exception {
        if (archiveName == null) {
            SemanticTypeInfo typeInfo;
            SemanticTypeInfo semanticTypeInfo = typeInfo = type != null ? SemanticUtils.getSemanticTypeInfo(type, (RuntimeContext)this.callable) : SemanticUtils.getSemanticTypeInfo(className, (RuntimeContext)this.callable);
            if (typeInfo.getLibJar() == null) {
                throw new Exception("Archive with SDO class not found in 'lib' area of Repository.");
            }
            return typeInfo.getLibJar();
        }
        if (SemanticUtils.existsClassInArchive(archiveName, ((RuntimeContext)this.callable).getRepositoryAccessor().getArchiveURL(archiveName))) {
            return archiveName;
        }
        if (ifexists) {
            return null;
        }
        throw new Exception("Archive '" + archiveName + "' does not contain SDO class '" + className + "'.");
    }

    protected void checkThatPackageWithArchiveIsUnloaded(String archiveName) throws Exception {
        PackageDescriptor pkg = ((RuntimeContext)this.callable).getPackageManifestManager().getPackageByArchive(archiveName);
        if (pkg != null && ((RuntimeContext)this.callable).getPackageManifestManager().isPackageLoaded(pkg.getFullName())) {
            throw new Exception("SDO archive '" + archiveName + "' is loaded in package '" + pkg.getFullName() + "' and cannot be dropped.");
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        DSLStatement statement;

        public Definition(String name, DSLStatement statement) {
            super(name);
            this.statement = statement;
        }

        public DSLStatement getStatement() {
            return this.statement;
        }
    }
}

