/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.lib.jar.JarFile;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.AbstractSdoOperation;
import com.streamscape.runtime.mf.operation.edl.EDLException;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.utils.SemanticTypeInfo;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.function.Consumer;

public abstract class AbstractCreateSdoOperation
extends AbstractSdoOperation {
    protected static void addCommonAfterBodyModifiers(DSLStatementSyntax syntax) {
        CreateSdoAfterBodyParameters.addAfterBodyModifiers(syntax);
    }

    protected static String getCommonAfterBodyModifiersDescription() {
        return CreateSdoAfterBodyParameters.getAfterBodyModifiersDescription();
    }

    @Override
    protected SLResponse doInvoke(AbstractSdoOperation.Definition definition, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        SemanticType semanticType;
        DSLStatement statement = definition.getStatement();
        CreateSdoAfterBodyParameters params = CreateSdoAfterBodyParameters.parseAfterBodyModifiers(this, statement, true);
        String objectName = statement.getParameter("ObjectName").getValue();
        String alias = statement.getParameter("AliasName").getValue();
        String fullClassName = SdoUtils.makeFullClassName(params.namespace, objectName);
        SemanticTypeInfo typeInfo = SemanticUtils.getSemanticTypeInfo(fullClassName, (RuntimeContext)this.callable);
        if (typeInfo.getExtJar() != null) {
            throw new Exception("SDO class '" + fullClassName + "' already exists in ext archive '" + typeInfo.getExtJar() + "'.");
        }
        if (typeInfo.getLibJar() != null && !typeInfo.getLibJar().equals(params.archiveName)) {
            throw new Exception("SDO class '" + fullClassName + "' already exists in lib archive '" + typeInfo.getLibJar() + "'.");
        }
        if (!params.noType && (semanticType = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(objectName)) != null) {
            if (semanticType.isSystem()) {
                throw new EDLException("Semantic type with name '" + objectName + "' is system type and cannot be changed.");
            }
            if (!semanticType.getClassName().equals(fullClassName)) {
                throw new EDLException("Semantic type with name '" + objectName + "' already exists and references another class '" + semanticType.getClassName() + "'.");
            }
        }
        if (params.addArchive && ((RuntimeContext)this.callable).getRepositoryAccessor().existsArchive(params.archiveName)) {
            JarFile jarFile = SemanticUtils.getLibJarFile(params.archiveName, (RuntimeContext)this.callable);
            String objectPathInJar = SdoUtils.getClassPathInJar(fullClassName);
            String validatorPathInJar = SdoUtils.getValidatorClassPathInJar(fullClassName);
            if (jarFile.existsEntry(objectPathInJar)) {
                throw new Exception("Target archive '" + params.archiveName + "' already contains class '" + objectPathInJar + "'.");
            }
            if (jarFile.existsEntry(validatorPathInJar)) {
                throw new Exception("Target archive '" + params.archiveName + "' already contains class '" + validatorPathInJar + "'.");
            }
        }
        Package pkg = null;
        if (((RuntimeContext)this.callable).getRepositoryAccessor().existsPackage(PackageType.sdo, params.packageName)) {
            pkg = ((RuntimeContext)this.callable).getRepositoryAccessor().getPackage(PackageType.sdo, params.packageName);
            if (params.addPackage && pkg.containsJAR(params.archiveName)) {
                throw new Exception("Target package '" + params.packageName + "' already contains archive '" + params.archiveName + "'.");
            }
        }
        boolean packageUpdated = this.onGenerateSdoAndWriteToJarFile(fullClassName, alias, statement, params, feedbackInvoker);
        if (pkg == null) {
            pkg = Package.create(PackageType.sdo, params.packageName);
        }
        boolean needToReloadPackage = false;
        if (!pkg.containsJAR(params.archiveName)) {
            pkg.addJAR(params.archiveName);
            needToReloadPackage = true;
        }
        boolean needToUpdatePackage = !packageUpdated && !params.addPackage;
        String pkgFullName = pkg.getFullName();
        if (needToReloadPackage || needToUpdatePackage) {
            if (((RuntimeContext)this.callable).getRepositoryAccessor().existsPackage(PackageType.sdo, params.packageName)) {
                boolean wasLoaded = ((RuntimeContext)this.callable).getPackageManifestManager().isPackageLoaded(pkgFullName);
                if (needToReloadPackage && wasLoaded) {
                    ((RuntimeContext)this.callable).getPackageManifestManager().unloadPackage(pkgFullName, false);
                    feedbackInvoker.addFeedback("Package '" + pkgFullName + "' unloaded.\n");
                }
                this.updatePackageObject(pkg);
                feedbackInvoker.addFeedback("Package '" + pkgFullName + "' updated.\n");
                if (needToReloadPackage && wasLoaded) {
                    ((RuntimeContext)this.callable).getPackageManifestManager().loadPackage(pkgFullName, false);
                    feedbackInvoker.addFeedback("Package '" + pkgFullName + "' loaded.\n");
                }
            } else {
                ((RuntimeContext)this.callable).getRepositoryAccessor().addPackage(pkg);
                feedbackInvoker.addFeedback("Package '" + pkgFullName + "' created.\n");
            }
        }
        if (!params.noType) {
            if (!((RuntimeContext)this.callable).getPackageManifestManager().existsPackage(Package.getFullName(PackageType.sdo, params.packageName))) {
                ((RuntimeContext)this.callable).getPackageManifestManager().addPackage(PackageDescriptor.create(pkg, true, params.noGlobal == null));
                feedbackInvoker.addFeedback("Package '" + pkg.getFullName() + "' registered in Runtime Package Manifest and automatically loaded.\n");
            }
            if (!((RuntimeContext)this.callable).getPackageManifestManager().isPackageLoaded(Package.getFullName(PackageType.sdo, params.packageName))) {
                ((RuntimeContext)this.callable).getPackageManifestManager().loadPackage(Package.getFullName(PackageType.sdo, params.packageName), false);
                feedbackInvoker.addFeedback("Package '" + pkg.getFullName() + "' loaded.\n");
            }
            this.updateSemanticType(objectName, fullClassName, params, feedbackInvoker, true);
            this.createSemanticTypesForNestedClasses(params.archiveName, fullClassName, feedbackInvoker);
        } else {
            SemanticType semanticType2 = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(objectName);
            if (semanticType2 != null) {
                TypeFactory.removeSemanticType(semanticType2.getTypeName(), true);
                feedbackInvoker.addFeedback("Semantic type '" + semanticType2.getTypeName() + "' removed.\n");
            }
        }
        return new SLResponse();
    }

    protected abstract boolean onGenerateSdoAndWriteToJarFile(String var1, String var2, DSLStatement var3, CreateSdoAfterBodyParameters var4, AbstractDSLOperation.FeedbackInvoker var5) throws Exception;

    public static class CreateSdoAfterBodyParameters {
        public boolean create;
        public String namespace;
        public String archiveName;
        public String packageName;
        public boolean addArchive = false;
        public boolean addPackage = false;
        public boolean noValidate;
        public Boolean noGlobal;
        public String ancestor = null;
        public boolean isInterface = false;
        public String description = null;
        public boolean noSource = false;
        public boolean noType = false;
        public boolean noDoc = false;
        public boolean ancestorPresent = false;
        public boolean descriptionPresent = false;
        public boolean isInterfacePresent = false;

        protected CreateSdoAfterBodyParameters(boolean create) {
            this.create = create;
        }

        public static void addAfterBodyModifiers(DSLStatementSyntax syntax) {
            CreateSdoAfterBodyParameters.addAfterBodyNamespaceArchivePackageModifiers(syntax);
            syntax.addModifier(AbstractSdoOperation.createAncestorModifier());
            syntax.addModifier(AbstractSdoOperation.createIsInterfaceModifier());
            syntax.addModifier(AbstractSdoOperation.createDescriptionModifier());
            syntax.addModifier(AbstractSdoOperation.createNoSourceModifier());
            syntax.addModifier(AbstractSdoOperation.createNoTypeModifier());
            syntax.addModifier(AbstractSdoOperation.createNoDocModifier());
            syntax.addModifier(AbstractSdoOperation.createNoValidateModifier());
            syntax.addModifier(AbstractSdoOperation.createNoGlobalModifier());
        }

        public static void addAfterBodyNamespaceArchivePackageModifiers(DSLStatementSyntax syntax) {
            CreateSdoAfterBodyParameters.addAfterBodyNamespaceArchivePackageModifiers(syntax::addModifier);
        }

        public static void addAfterBodyNamespaceArchivePackageModifiers(Consumer<AbstractModifier> consumer) {
            consumer.accept(AbstractSdoOperation.createNamespaceModifier());
            CompoundModifier addArchive = new CompoundModifier("compoundaddreplacearchive");
            addArchive.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("addreplacearchive").addModifier((AbstractModifier)new Modifier("ADD").setName("ADDARCHIVE"))).addModifier((AbstractModifier)new Modifier("REPLACE").setName("REPLACEARCHIVE")));
            addArchive.addModifier(new Modifier("ARCHIVE"));
            addArchive.addParameter((AbstractParameter)new IdentifierParameter("Archive Name").setName("ArchiveName"));
            consumer.accept(addArchive);
            CompoundModifier addPackage = new CompoundModifier("compoundaddreplacepackage");
            addPackage.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("addreplacepackage").addModifier((AbstractModifier)new Modifier("ADD").setName("ADDPACKAGE"))).addModifier((AbstractModifier)new Modifier("REPLACE").setName("REPLACEPACKAGE")));
            addPackage.addModifier(new Modifier("PACKAGE"));
            addPackage.addParameter((AbstractParameter)new IdentifierParameter("Package Name").setName("PackageName"));
            consumer.accept(addPackage);
        }

        private static IdentifierParameter createArchiveParameter(String prefix) {
            return (IdentifierParameter)new IdentifierParameter("Archive Name").setName(prefix + "ArchiveName");
        }

        public static String getAfterBodyModifiersDescription() {
            return "   ns <Namespace>                - Java package where SDO class is located.\n   add archive <ArchiveName>     - Adds SDO class to archive <ArchiveName>,\n                                   Makes error if archive already exists and contains SDO class.\n   replace archive <ArchiveName> - Replaces SDO in archive <ArchiveName>.\n   add package <PackageName>     - Adds archive to package <PackageName>,\n                                   Makes error if package already exists and contains SDO class.\n   replace package <PackageName> - Replaces SDO in package <PackageName>.\n   ancestor <SemanticType>       - Ancestor for SDO semantic type.\n   interface {true | false}      - Interface field for SDO semantic type.\n   description '<Description>'   - Description for SDO semantic type.\n   no source                     - Indicates not to generate SDO source code.\n   no type                       - Indicates not to register type.\n   no doc                        - Indicates not to generate HTML documentation.\n   no validate                   - Indicates not to validate package-dependent entities (semantic types and prototypes).\n   no global                     - Indicates to create a node-local package. Local packages are not replicated to other nodes of Sysplex.\n                                   This parameter is applicable only with the 'add package' parameter.\n   with wait                     - Executes this operation in synchronous mode (waits until completion).";
        }

        public static CreateSdoAfterBodyParameters parseAfterBodyModifiers(AbstractDSLOperation operation, DSLStatement statement, boolean create) throws Exception {
            CreateSdoAfterBodyParameters params = new CreateSdoAfterBodyParameters(create);
            if (create) {
                params.namespace = statement.getParameter("namespace").getValue();
                params.archiveName = SdoUtils.makeArchiveName(statement.getParameter("ArchiveName").getValue());
                params.packageName = SdoUtils.makeSimplePackageName(statement.getParameter("PackageName").getValue());
                params.addArchive = statement.getModifier("addreplacearchive").getToken().equalsIgnoreCase("ADD");
                params.addPackage = statement.getModifier("addreplacepackage").getToken().equalsIgnoreCase("ADD");
                if (statement.existsModifier("NO GLOBAL")) {
                    if (!params.addPackage) {
                        throw new ParsingException(operation.getSyntaxErrorMessage("Parameter 'no global' is only applicable with parameter 'add package'."));
                    }
                    params.noGlobal = true;
                }
            }
            params.ancestorPresent = statement.existsParameter("AncestorSemanticType");
            params.ancestor = statement.existsParameter("AncestorSemanticType") ? statement.getParameter("AncestorSemanticType").getValue() : "object";
            params.descriptionPresent = statement.existsParameter("description");
            params.description = statement.existsParameter("description") ? statement.getParameter("description").getValue() : "";
            params.isInterfacePresent = statement.existsModifier("ISINTERFACE");
            params.isInterface = statement.existsModifier("ISINTERFACE") && statement.getModifier("ISINTERFACE").getToken().equalsIgnoreCase("TRUE");
            params.noSource = statement.existsModifier("nosource");
            params.noType = statement.existsModifier("notype");
            params.noDoc = statement.existsModifier("nodoc");
            params.noValidate = AbstractSdoOperation.isNoValidate(statement);
            return params;
        }
    }
}

