/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.omf.java.Utils;
import com.streamscape.omf.xsd.EdlGenerator;
import com.streamscape.omf.xsd.Parser;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractSdoOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileInputStreamFactory;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.tools.lexer.BufferUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractCreateSdoFromXsdXmlOperation
extends AbstractSdoOperation {
    public static void appendFileModifier(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("FILE_CONTENT").addModifier((AbstractModifier)((Modifier)new Modifier("FILE").addParameter(new SLFilePathParameter("filename"))).setSyntaxHint(SyntaxHint.SPACE))).addModifier((AbstractModifier)((Modifier)new Modifier().addParameter(new StringParameter("content"))).setSyntaxHint(SyntaxHint.SPACE)));
    }

    public static String getFileModifierDescription(String filetype) {
        return "   <filename>                    - Path to the " + filetype + " file.\n";
    }

    public static void appendSaveBuildModifier(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)new CompoundModifier().addModifier(new Modifier("SAVE")).addModifier(new ChoiceModifier().addPossibleValue("AT").addPossibleValue("@")).addParameter(new SLFilePathParameter("edlFile")).setRequired(false));
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("BUILD").setName("build")).setRequired(false));
    }

    public static String getSaveBuildModifierDescription() {
        return "   <edlFile>                     - Output file with EDL statements.\n   build                         - Executes created EDL statements.\n";
    }

    public static void appendSimpleTypeAsStringModifier(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SIMPLE TYPES AS STRING").setName("typesasstring")).setRequired(false));
    }

    public static String getSimpleTypeAsStringModifierDescription() {
        return "   simple types as string        - Replaces all simple types with STRING, doesn't generate IN RANGE restriction.\n";
    }

    public static void appendWithDefaultsModifier(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("WITH DEFAULTS").setName("withdefaults")).setRequired(false));
    }

    public static String getWithDefaultsModifierDescription() {
        return "   with defaults                 - Assigns defaults values to fields.\n";
    }

    public static void appendTypesModifier(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TYPES").addParameter(new SetParameter("typesset").addParameter(new StringParameter("path")).addParameter(new IdentifierParameter("type")))).setRequired(false));
    }

    public static void appendAliasesModifier(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ALIASES").addParameter(new SetParameter("aliasesset").addParameter(new StringParameter("path")).addParameter(new StringParameter("alias")))).setRequired(false));
    }

    public static String getTypesModifierDescription() {
        return "   types('<path>' <type>,...)    - Defines types for specified elements.\n                                   Type should be simple type supported by EDL or name of Semantic Type.\n";
    }

    public static String getAliasesModifierDescription() {
        return "   aliases('<path>' '<alias>',...) - Defines aliases for specified elements.\n";
    }

    @Override
    protected SLResponse doInvoke(AbstractSdoOperation.Definition definition, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        Map<String, String> edls;
        DSLStatement statement = definition.getStatement();
        EdlGenerator generator = AbstractCreateSdoFromXsdXmlOperation.createEdlGenerator(this, statement, this.onCreateParser(statement));
        this.onUpdateGenerator(statement, generator);
        feedbackInvoker.addFeedback("\nGenerating EDL...\n\n");
        try (InputStream inputStream = this.openInputFileStream(feedbackInvoker.getMFSession(), statement);){
            edls = generator.generateEdl(inputStream);
        }
        feedbackInvoker.addFeedback("\nEDL generated.\n");
        String javaDoc = BufferUtils.extractJavaDoc(definition.statement.getOriginalStatement()).stream().map(s -> s.trim()).filter(s -> s.length() > 0).collect(Collectors.joining("\n")).trim();
        if (javaDoc != null && javaDoc.length() > 0) {
            String key = edls.keySet().toArray(new String[edls.size()])[edls.size() - 1];
            edls.put(key, javaDoc + "\n" + edls.get(key));
        }
        return AbstractCreateSdoFromXsdXmlOperation.buildAndSaveEdls(statement, edls, feedbackInvoker);
    }

    protected void onUpdateGenerator(DSLStatement statement, EdlGenerator generator) {
    }

    protected abstract Parser onCreateParser(DSLStatement var1) throws Exception;

    public static EdlGenerator createEdlGenerator(AbstractDSLOperation operation, DSLStatement statement, Parser parser) throws Exception {
        int i;
        StatementSetValue typesSet;
        AbstractCreateSdoOperation.CreateSdoAfterBodyParameters params = AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.parseAfterBodyModifiers(operation, statement, true);
        EdlGenerator generator = new EdlGenerator(true);
        if (params.namespace != null) {
            generator.setNamespace(params.namespace);
        }
        generator.setAddArchive(params.addArchive);
        generator.setArchiveName(params.archiveName);
        generator.setAddPackage(params.addPackage);
        generator.setPackageName(params.packageName);
        generator.setAncestor(params.ancestor);
        generator.setDescription(params.description);
        generator.setInterface(params.isInterface);
        generator.setNoDoc(params.noDoc);
        generator.setNoType(params.noType);
        generator.setNoSource(params.noSource);
        generator.setParser(parser);
        generator.setSimpleTypesAsString(statement.existsModifier("typesasstring"));
        generator.setWithDefaults(statement.existsModifier("withdefaults"));
        HashMap<String, String> typesMap = null;
        if (statement.existsSet("typesset")) {
            typesMap = new HashMap<String, String>();
            typesSet = statement.getSet("typesset");
            for (i = 0; i < typesSet.size(); ++i) {
                typesMap.put(typesSet.getElement(i).getParameter("path").getValue(), typesSet.getElement(i).getParameter("type").getValue());
            }
        }
        generator.setTypesMap(typesMap);
        HashMap<String, String> aliasesMap = null;
        if (statement.existsSet("aliasesset")) {
            aliasesMap = new HashMap<String, String>();
            typesSet = statement.getSet("aliasesset");
            for (i = 0; i < typesSet.size(); ++i) {
                aliasesMap.put(typesSet.getElement(i).getParameter("path").getValue(), typesSet.getElement(i).getParameter("alias").getValue());
            }
        }
        generator.setAliasesMap(aliasesMap);
        return generator;
    }

    public static Collection<String> generateEdls(EdlGenerator generator, InputStream inputStream) throws Exception {
        return generator.generateEdl(inputStream).values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SLResponse buildAndSaveEdls(DSLStatement statement, Map<String, String> edls, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        if (statement.existsModifier("build")) {
            FabricConnection connection = new FabricConnectionFactory().createConnection();
            SLSession slSession = null;
            try {
                connection = new FabricConnectionFactory().createConnection();
                connection.open();
                slSession = connection.createSLSession();
                ArrayList<String> keys = new ArrayList<String>(edls.keySet());
                Collections.reverse(keys);
                for (String key : keys) {
                    String edl = "unregister type " + key + " force if exists";
                    feedbackInvoker.addFeedback("\n" + edl + "\n");
                    feedbackInvoker.addLongFeedback("Executing EDL...");
                    SLResponse response = slSession.slangRequest(edl, 30000L);
                    if (!response.isOK()) {
                        throw response.getException() instanceof Exception ? (Exception)response.getException() : new Exception(response.getText());
                    }
                    feedbackInvoker.completeLongFeedback();
                }
                for (String edl : edls.values()) {
                    feedbackInvoker.addFeedback("\n" + edl + "\n");
                    feedbackInvoker.addLongFeedback("Executing EDL...");
                    SLResponse response = slSession.slangRequest(edl, 30000L);
                    if (!response.isOK()) {
                        throw response.getException() instanceof Exception ? (Exception)response.getException() : new Exception(response.getText());
                    }
                    feedbackInvoker.completeLongFeedback();
                }
            }
            finally {
                if (slSession != null) {
                    slSession.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
        AbstractCreateSdoFromXsdXmlOperation.createOutputEdlFile(statement, edls, feedbackInvoker);
        return new SLResponse();
    }

    protected InputStream openInputFileStream(MFSession session, DSLStatement statement) throws Exception {
        if (statement.getParameter("filename").isPresent()) {
            String filename = statement.getParameter("filename").getValue();
            SLFileInputStream inputStream = (SLFileInputStream)new SLFileInputStreamFactory().create(session, filename);
            try {
                inputStream.open();
            }
            catch (Exception exception) {
                throw new Exception("File '" + filename + "' does not exist.");
            }
            return new BufferedInputStream(inputStream, session.getSLSessionData().getTransferBufferSize());
        }
        String content = statement.getParameter("content").getValue();
        return new ByteArrayInputStream(content.getBytes());
    }

    protected static void createOutputEdlFile(DSLStatement statement, Map<String, String> edls, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        String outputEdlFileName = statement.existsParameter("edlFile") ? statement.getParameter("edlFile").getValue() : null;
        ArrayList<String> keys = new ArrayList<String>(edls.keySet());
        Collections.reverse(keys);
        Object builder = keys.stream().map(name -> "unregister type " + name + " force if exists\n").collect(Collectors.joining());
        builder = (String)builder + edls.values().stream().map(edl -> "set delimiter $$\n" + edl + "$$\nset delimiter\n\n").collect(Collectors.joining());
        if (outputEdlFileName != null) {
            feedbackInvoker.addFeedback("\nSaving EDL output file...\n");
            Utils.sleep(50L);
            try {
                ((SLFileUtils)new SLFileUtilsFactory().create(feedbackInvoker.getMFSession(), outputEdlFileName)).createFile(((String)builder).getBytes(), false);
            }
            catch (IOException exception) {
                throw new Exception("Writing output edl file '" + outputEdlFileName + "' failed", exception);
            }
            feedbackInvoker.addFeedback("EDL output file saved.\n");
        } else if (!statement.existsModifier("build")) {
            feedbackInvoker.addFeedback("\n" + (String)builder);
        }
    }
}

