/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.edl;

import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.AbstractCreateSdoOperation;
import com.streamscape.runtime.mf.operation.edl.AbstractSdoOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;

abstract class AbstractAlterSdoOperation
extends AbstractSdoOperation {
    AbstractAlterSdoOperation() {
    }

    protected void addCommonAfterBodyModifiers(DSLStatementSyntax syntax) {
        syntax.addModifier(AbstractAlterSdoOperation.createAncestorModifier());
        syntax.addModifier(AbstractAlterSdoOperation.createIsInterfaceModifier());
        syntax.addModifier(AbstractAlterSdoOperation.createDescriptionModifier());
        syntax.addModifier(AbstractAlterSdoOperation.createNoSourceModifier());
        syntax.addModifier(AbstractAlterSdoOperation.createNoDocModifier());
        syntax.addModifier(AbstractAlterSdoOperation.createNoValidateModifier());
    }

    protected String getCommonAfterBodyModifiersDescription() {
        return "   ancestor <SemanticType>     - Ancestor for SDO semantic type if semantic type exists.\n   interface {true | false}    - Interface field for SDO semantic type if semantic type exists.\n   description '<Description>' - Description for SDO semantic type if semantic type exists.\n   no source                   - Indicates not to generate SDO source code.\n   no doc                      - Indicates not to generate HTML documentation.\n   no validate                 - Indicates not to validate package-dependent entities (semantic types and prototypes).\n   with wait                   - Executes this operation in synchronous mode (waits until completion).";
    }

    @Override
    protected SLResponse doInvoke(AbstractSdoOperation.Definition definition, AbstractDSLOperation.FeedbackInvoker feedbackInvoker) throws Exception {
        DSLStatement statement = definition.getStatement();
        String objectName = statement.getParameter("ObjectName").getValue();
        String alias = statement.getParameter("AliasName").getValue();
        objectName = this.resolveTypeName(objectName);
        SemanticType type = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(objectName);
        if (type == null) {
            throw new Exception("Semantic type for SDO '" + objectName + "' not found.");
        }
        if (type.isSystem()) {
            throw new Exception("System semantic type '" + objectName + "' cannot be changed.");
        }
        String fullClassName = type.getClassName();
        AbstractCreateSdoOperation.CreateSdoAfterBodyParameters params = AbstractCreateSdoOperation.CreateSdoAfterBodyParameters.parseAfterBodyModifiers(this, statement, false);
        params.archiveName = this.lookupArchiveWithClass(null, type, fullClassName, false);
        this.onGenerateSdoAndWriteToJarFile(fullClassName, alias, statement, params, feedbackInvoker);
        if (((RuntimeContext)this.callable).getSemanticTypeCache().existsSemanticType(objectName)) {
            this.updateSemanticType(objectName, fullClassName, params, feedbackInvoker, false);
        }
        this.createSemanticTypesForNestedClasses(params.archiveName, fullClassName, feedbackInvoker);
        return new SLResponse();
    }

    protected abstract void onGenerateSdoAndWriteToJarFile(String var1, String var2, DSLStatement var3, AbstractCreateSdoOperation.CreateSdoAfterBodyParameters var4, AbstractDSLOperation.FeedbackInvoker var5) throws Exception;
}

