/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class UnshareFileDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "unshare file";

    public UnshareFileDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("UNSHARE FILE").addModifier((AbstractModifier)new Modifier("WITH RESOURCE ID").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("resource Id").setName("resourceId")).setCompletionAdviser(new SharedFileResoucesIdCompleter())));
        this.syntax.setDescription("Unshares file resource with specified ID.");
        this.syntax.addTag("share");
    }

    protected String getParameterName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxName();
    }

    protected String getParameterNodeName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxAccessor().getDropBox().getNodeName();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse onInvoke(SLStatement definition, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        DropBox dropBox = accessor.getDropBox();
        String resourceId = statement.getParameter("resourceId").getValue();
        DropBoxSharedResources.DropBoxSharedResource resource = dropBox.getSharedResources().getResourceById(resourceId);
        boolean isOwner = DropBoxUtils.isOwner(dropBox, session.getOwnerName());
        boolean isAdmin = DropBoxUtils.isAdmin(this.getRuntimeContext(), session.getOwnerName());
        if (resource == null || !isAdmin && !isOwner && !resource.getUsername().equalsIgnoreCase(session.getOwnerName())) {
            throw new DropBoxException("Resource with specified ID not found or owned by another user.");
        }
        accessor.removeSharedResource(resourceId);
        return new SLResponse();
    }

    public static class SharedFileResoucesIdCompleter
    implements CompletionAdviser<DropBoxConnectionService> {
        @Override
        public List<String> getCompletions(String script, String processedScript, DropBoxConnectionService callable, MFSession session) {
            return new ArrayList<String>(callable.getDropBoxAccessor().getDropBox().getSharedResources().getResources().stream().map(r -> r.getResourceId()).collect(Collectors.toList()));
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(UnshareFileDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

