/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.parameter.TimeUnitParameter;

public class ShareFileDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "share file";

    public ShareFileDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHARE FILE").addActionParameter(new DropBoxPathParameter("path", DropBoxAccessor.DropBoxPathNotation.FOLDERS));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("AS").addParameter((SyntaxParameter)new IdentifierParameter("resource Id").setName("resourceId"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new Modifier("PUBLIC").setRequired(false));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("EXPIRES_CHOICE").setRequired(false)).addModifier((AbstractModifier)new Modifier("EXPIRES ON").addParameter((SyntaxParameter)new StringParameter("expiration date").setName("expiresAt")))).addModifier((AbstractModifier)((Modifier)new Modifier("EXPIRES IN").addParameter((SyntaxParameter)new LongParameter("interval").setName("expiresIn"))).addParameter((SyntaxParameter)new TimeUnitParameter().setName("expiresInTimeUnit"))));
        this.syntax.setDescription("Shares specified DropBox file and returns unique resource ID.\n\nURI for shared resource can be changed in API customizer:\n\n    alter acceptor HTTP.Default add rule AnyRule (externalURI='/myfiles/{+}', httpMethod='GET', returnCode='200', customizedUri='/dropbox/share/sampledropbox/uri{+}', customizedMethod='GET', redirect='false')\n\nor directly to file\n\n    alter acceptor HTTP.Default add rule AnyRule (externalURI='/myfile', httpMethod='GET', returnCode='200', customizedUri='/dropbox/share/sampledropbox/myfile', customizedMethod='GET', redirect='false')\n\nNOTE: also need to add realm for external URI\n\nParameters:\n\n   path        - resource path in DropBox\n   resourceId  - resource ID which will be shown to user or auto-generated\n   public      - if specified then resources is available to registered users only otherwise to everyone\n   expires on  - date when token expires in format yyyy-mm-dd hh:mm:ss.SSS\n   expires in  - expiration interval since creation\n");
        this.syntax.setExamples("share file myfolder/myfile.txt as 'myfile'\nshare file myfolder/myfile.txt expires on '2022-09-05 11:11:11.000'\nshare file myfolder/myfile.txt expires in 10 sec");
        this.syntax.addTag("share");
    }

    protected String getParameterName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxName();
    }

    protected String getParameterNodeName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxAccessor().getDropBox().getNodeName();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse onInvoke(SLStatement definition, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        String path = statement.getParameter("path").getValue();
        String resourceId = statement.getParameter("resourceId").getValue();
        DropBoxSharedResources.DropBoxSharedResource.ShareMethod shareMethod = statement.existsModifier("PUBLIC") ? DropBoxSharedResources.DropBoxSharedResource.ShareMethod.PUBLIC : DropBoxSharedResources.DropBoxSharedResource.ShareMethod.SHARED;
        Long[] expiresAt = new Long[]{0L};
        if (statement.existsParameter("expiresAt")) {
            expiresAt[0] = DataspaceDateTime.convertMillisToCalendar(DataspaceDateTime.getCalendar(), DataspaceDateTime.getSqlTimestampMilliseconds(statement.getParameter("expiresAt").getValue(), DataspaceDateTime.getTimezone().toString())) / 1000L;
        } else if (statement.existsParameter("expiresIn")) {
            Long expiresIn = TimeUnitParameter.parseValue(statement.getParameter("expiresInTimeUnit").getValue()).toMillis(Long.valueOf(statement.getParameter("expiresIn").getValue()));
            expiresAt[0] = System.currentTimeMillis() + expiresIn;
        }
        String fullPath = DropBoxUtils.isEmptyOrDotPath(callable.getCurrentPath()) ? path : DropBoxUtils.normalizePath(callable.getCurrentPath() + "/" + path);
        try (FileSystem fileSystem = accessor.createFileSystem(session.getOwnerName(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);){
            if (!fileSystem.exists(fullPath)) {
                throw new DropBoxException("Specified path doesn't exist: " + fullPath);
            }
            if (!fileSystem.isFile(fullPath)) {
                throw new DropBoxException("Specified path is not file: " + fullPath);
            }
        }
        DropBoxUtils.checkFullAccessAny(accessor.getDropBox(), session.getOwnerName(), fullPath, DropBoxAccessor.DropBoxPathNotation.FOLDERS);
        if (resourceId != null && accessor.getDropBox().getSharedResources().getResourceById(resourceId) != null) {
            throw new DropBoxException("Resource with ID " + resourceId + " already exists.");
        }
        DropBoxSharedResources.DropBoxSharedResource resource = accessor.createSharedResource(fullPath, resourceId, expiresAt[0], session.getOwnerName(), shareMethod);
        return new SLResponse(resource.getResourceId());
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(ShareFileDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

