/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.sql.SQLException;
import java.util.List;

public class ListSharedFilesDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "list shared files";

    public ListSharedFilesDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST SHARED FILES");
        this.syntax.setDescription("Returns list of shared files in this DropBox.");
        this.syntax.addTag("share");
    }

    protected String getParameterName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxName();
    }

    protected String getParameterNodeName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxAccessor().getDropBox().getNodeName();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse onInvoke(SLStatement statement, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        DropBox dropBox = accessor.getDropBox();
        if (dropBox == null) {
            throw new Exception("Specified dropbox doesn't exist.");
        }
        return new SLResponse(ListSharedFilesDropBoxOperation.listSharedFiles(dropBox.getSharedResources().getResources(), dropBox, this.getRuntimeContext(), session));
    }

    public static RowSet listSharedFiles(List<DropBoxSharedResources.DropBoxSharedResource> resources, DropBox dropBox, RuntimeContext runtimeContext, MFSession session) throws SQLException {
        RowSet rowSet = new RowSet(new RowMetaData().addColumn("Path", String.class).addColumn("Resource ID", String.class).addColumn("Share Method", String.class).addColumn("Owner", String.class).addColumn("Expires", String.class).addColumn("Created", String.class).addColumn("URL", String.class));
        boolean isOwner = DropBoxUtils.isOwner(dropBox, session.getOwnerName());
        boolean isAdmin = DropBoxUtils.isAdmin(runtimeContext, session.getOwnerName());
        for (DropBoxSharedResources.DropBoxSharedResource resource : resources) {
            if (!isOwner && !isAdmin && !resource.getUsername().equalsIgnoreCase(session.getOwnerName())) continue;
            rowSet.addToRowSet(new Object[]{resource.getPath(), resource.getResourceId(), resource.getShareMethod().name(), resource.getUsername(), resource.getExpiresAt() > 0L ? DataspaceDateTime.trimMills(ListSharedFilesDropBoxOperation.formatDateMillis(resource.getExpiresAt())) : "never", DataspaceDateTime.trimMills(ListSharedFilesDropBoxOperation.formatDateMillis(resource.getCreatedAt())), DropBoxSharedResources.buildSharedResourceUrl(dropBox.getName(), resource)});
        }
        return rowSet;
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(ListSharedFilesDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

