/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.Trace;
import com.streamscape.ds.lib.StringComparator;
import com.streamscape.omf.java.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractDropBoxOperation;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxTable;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ListDropBoxOperation
extends AbstractDropBoxOperation<RuntimeContext> {
    public static final String NAME = "list dropbox";

    public ListDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST DROPBOX");
        this.syntax.addParameter((AbstractParameter)new ExpressionParameter("mask", '(', ')').setRequired(false));
        this.syntax.addModifier((AbstractModifier)new AtNodeOrAtDomainModifier().setRequired(false));
        this.syntax.addModifier((AbstractModifier)((BlockModifier)new BlockModifier("OWNER").setName("ownerblock")).addModifier((AbstractModifier)new RepeatableModifier("repeatable").addParameter(new StringParameter("owner"))).setRequired(false));
        this.syntax.setDescription("A Drop Box is a secure exchange point for files, similar to a managed FTS site or Cloud Storage service.\n\nThis command returns list of all registered Drop Boxes in a domain, a specific or current node. Results\nmay be filtered by Dropbox name, mask or wild card to search for specific Dropbox profiles.\n\nFilter Example:\n\n       list dropbox (a%)\n       list dropbox (s???admin)\n\nWhere % may be any string and ? may be any character used to filter\n\n       list dropbox owner ('Bob')\n\nOwner name must be in quotes and does not support wild cards or masks\n\nIf the modifier @ DOMAIN is specified then all profiles for all users are shown within a Domain.\n\nDropbox Profiles are synchronized across the Domain, however actual storage is tied to a specific node\nwhere the content is hosted. Any node can access any Dropbox, but may incur the overhead of remote file\nprocessing as data content is moved across the network in chunks to the node where a data request is made.\n\nThe following information is available in a Dropbox Profile and may be retrieved using a combination of\ncommands such as DESCRIBE DROPBOX, LIST DROPBOX with modifiers:\n\n        Name                       The Global (unique) name of a Dropbox\n        Host Node                  The node that hosts the physical storage\n        Owner                      Owner of the Dropbox, which may be a Group\n        Managed By                 The Management Node that controls Dropbox host\n        Join Sequence Id           Domain Join sequence, used to troubleshoot network errors\n        State                      Current state of the Dropbox in the Domain\n        Root Folder                Physical directory (mount point) for the Dropbox\n        FS Client Factory          Implementation Factory for Dropbox Storage (File System or Hadoop)\n        Folder Count               Number of folders (top level directories) in a Dropbox\n        Enabled                    Security status of the Dropbox (disabled content is not removed)\n        Last Error                 Last error message or issue\n        Acceptors                  Network access point that can be used to connect\n        Size on Disk               Size of content (currently not implemented)\n\nDropbox States:\n\n        ONLINE_STANDALONE - DropBox is accessible only in local (hosted) node by owner\n        ONLINE_GLOBAL     - DropBox has joined the Domain and is accessible across the sysplex\n        OFFLINE           - DropBox host node is offline\n        DUPLICATE_NAME    - DropBox with this name already exists, duplicate is inaccessible\n        REJECTED          - DropBox is rejected for security or network reasons\n\nOnce created a Dropbox Profile is replicated to all Management Nodes in a Domain. If an MNode is offline,\nreplication and synchronization will resume once the node joins the sysplex. Profile name collision that\nmay result from an intermittent outage or network issue is resolved using internal Timestamp and Sequence\nmechanisms.  In the event there are valid duplicate definitions with active content, the first Dropbox to\njoin the Domain becomes the active one. The duplicate name will then have to be resolved by collaborative\naction between Owner and Administrator.\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        HashSet<String> owners = null;
        StatementBlockValue block = statement.getBlock("ownerblock");
        for (StatementValueList line : block.getLines()) {
            if (owners == null) {
                owners = new HashSet<String>();
            }
            owners.add(line.getParameter("owner").getValue());
        }
        return this.invokeDescribe(statement, session, timeout, owners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SLResponse invokeDescribe(DSLStatement statement, MFSession session, long timeout, Set<String> owners) {
        List<DropBox> dropBoxes;
        RowSet rowSet = new RowSet(new RowMetaData().addColumn("Name", String.class).addColumn("Node Name", String.class).addColumn("Root Folder", String.class).addColumn("FS Client Factory", String.class).addColumn("Folders Count", String.class).addColumn("Owner", String.class).addColumn("Enabled", String.class).addColumn("Status", String.class).addColumn("Managed By", String.class).addColumn("Sequence Id", String.class).addColumn("Last Error", String.class).addColumn("Acceptors", String.class));
        Pattern maskregexp = null;
        String mask = statement.getParameter("mask").getValue();
        if (mask != null) {
            mask = mask.replaceAll("%", ".*");
            mask = mask.replaceAll("\\?", ".?");
            maskregexp = Pattern.compile(mask);
        }
        List<DropBoxTable.DropBoxTableItem> itemsFromTable = ((RuntimeContext)this.callable).getDropBoxManagerRemote().getDropBoxTableManager().getDropBoxTable().getItems();
        itemsFromTable.sort((i1, i2) -> {
            int c = new StringComparator().compare(i1.getMnodeName(), i2.getMnodeName());
            if (c != 0) {
                return c;
            }
            c = new StringComparator().compare(i1.getDropBoxNodeName(), i2.getDropBoxNodeName());
            if (c != 0) {
                return c;
            }
            c = new StringComparator().compare(i1.getDropBoxName(), i2.getDropBoxName());
            return c;
        });
        String nodeName = AtNodeOrAtDomainModifier.getValue(statement);
        if ("*".equals(nodeName)) {
            dropBoxes = ((RuntimeContext)this.callable).getDropBoxManagerRemote().getDropBoxes();
        } else if (nodeName == null) {
            dropBoxes = ((RuntimeContext)this.callable).getDropBoxManager().getDropBoxes();
            itemsFromTable.removeIf(i -> !((RuntimeContext)this.callable).getName().equals(i.getDropBoxNodeName()));
        } else {
            dropBoxes = ((RuntimeContext)this.callable).getDropBoxManagerRemote().getDropBoxes(nodeName);
            itemsFromTable.removeIf(i -> !nodeName.equals(i.getDropBoxNodeName()));
        }
        for (DropBox dropBox : dropBoxes) {
            itemsFromTable.removeIf(i -> dropBox.getName().equals(i.getDropBoxName()) && dropBox.getNodeName().equals(i.getDropBoxNodeName()));
            if (!DropBoxUtils.hasUserAccess(dropBox, session.getOwnerName(), DropBoxAccessControlOperation.LIST) || maskregexp != null && !maskregexp.matcher(dropBox.getName()).matches() || owners != null && owners.size() > 0 && !owners.contains(dropBox.getOwner())) continue;
            try {
                String state = "OK";
                String lastError = "";
                String managedBy = "n/a";
                String sequenceId = "n/a";
                if (dropBox.isEnabled()) {
                    try (DropBoxAccessor accessor = ((RuntimeContext)this.callable).getName().equals(dropBox.getNodeName()) ? ((RuntimeContext)this.callable).getDropBoxManager().createDropBoxAccessor(dropBox.getName()) : ((RuntimeContext)this.callable).getDropBoxManagerRemote().createDropBoxAccessor(dropBox.getName());){
                        if (accessor == null) {
                            state = "ERROR";
                            lastError = "Acceptor not initialized.";
                        } else if (accessor.isError()) {
                            state = "ERROR";
                            if (accessor.getException() != null) {
                                lastError = Utils.formatExceptionWithUnrepeatedCauses(accessor.getException());
                            }
                        } else {
                            DropBoxTable.DropBoxTableItem item = ((RuntimeContext)this.callable).getDropBoxManagerRemote().getDropBoxTableManager().getDropBoxTable().lookupDropBoxTableItem(dropBox.getName(), dropBox.getNodeName());
                            if (item == null) {
                                state = DropBoxTable.DropBoxTableItemState.ONLINE_STANDALONE.toString();
                            } else {
                                state = item.getState().toString();
                                managedBy = item.getMnodeName();
                                sequenceId = String.valueOf(item.getJoinTimestamp());
                            }
                        }
                    }
                    catch (Exception exception) {
                        state = "ERROR";
                        lastError = "Acceptor not initialized.";
                    }
                } else {
                    state = "DISABLED";
                }
                rowSet.addToRowSet(new Object[]{dropBox.getName(), dropBox.getNodeName(), dropBox.getRootFolder(), dropBox.getFsClientFactory(), dropBox.getFolders().size(), dropBox.getOwner(), dropBox.isEnabled(), state, managedBy, sequenceId, lastError, DropBoxUtils.listAcceptorsForDropBox((RuntimeContext)this.callable, dropBox.getName()).stream().collect(Collectors.joining(","))});
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        for (DropBoxTable.DropBoxTableItem item : itemsFromTable) {
            try {
                if (maskregexp != null && !maskregexp.matcher(item.getDropBoxName()).matches() || owners != null && owners.size() > 0 && !owners.contains(item.getOwner())) continue;
                rowSet.addToRowSet(new Object[]{item.getDropBoxName(), item.getDropBoxNodeName(), "n/a", "n/a", "n/a", item.getOwner(), "n/a", item.getState().toString(), item.getMnodeName(), item.getJoinTimestamp(), "n/a", "n/a"});
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        return new SLResponse(rowSet);
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(ListDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

