/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.runtime.mf.operation.dropbox.UnshareFileDropBoxOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.sef.network.mf.admin.Acceptor;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GetSharedFileUrlDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "get shared file url";

    public GetSharedFileUrlDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("GET SHARED FILE URL").addActionParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("resource Id").setName("resourceId")).setCompletionAdviser(new UnshareFileDropBoxOperation.SharedFileResoucesIdCompleter()));
        this.syntax.addModifier((AbstractModifier)new CompoundModifier("FULL_ALL").addModifier(new Modifier("FULL")).addModifier((AbstractModifier)((Modifier)new Modifier("ALL").setAlias("*")).setRequired(false)).setRequired(false));
        this.syntax.setDescription("Returns URL for unique resource ID.\n\nParameters:\n\n    full     - return full URL for Default acceptor\n    full all - return fill URLs for all acceptors");
        this.syntax.addTag("share");
    }

    protected String getParameterName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxName();
    }

    protected String getParameterNodeName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxAccessor().getDropBox().getNodeName();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse onInvoke(SLStatement definition, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        String resourceId = statement.getParameter("resourceId").getValue();
        boolean full = statement.existsModifier("FULL");
        boolean all = statement.existsModifier("ALL");
        DropBox dropBox = accessor.getDropBox();
        DropBoxSharedResources.DropBoxSharedResource resource = dropBox.getSharedResources().getResourceById(resourceId);
        if (resource == null) {
            throw new DropBoxException("Resource with ID " + resourceId + " not found.");
        }
        String url = DropBoxSharedResources.buildSharedResourceUrl(dropBox.getName(), resource);
        if (full) {
            List acceptors = this.getRuntimeContext().getAcceptorManager().listRegisteredFactories().stream().map(name -> this.getRuntimeContext().getAcceptorManager().lookupFactory((String)name)).filter(f -> f.getName().startsWith("HTTP")).flatMap(f -> f.getAcceptors().stream()).collect(Collectors.toList());
            ArrayList<CallSite> urls = new ArrayList<CallSite>();
            if (acceptors.size() > 0) {
                if (all) {
                    urls.addAll(acceptors.stream().map(a -> a.getProtocol().getURLPrefix() + a.getURL() + url).collect(Collectors.toList()));
                } else {
                    Acceptor acceptor = acceptors.stream().filter(a -> a.getName().endsWith("Default")).findAny().orElse(null);
                    if (acceptor == null) {
                        acceptor = (Acceptor)acceptors.get(0);
                    }
                    urls.add((CallSite)((Object)(acceptor.getProtocol().getURLPrefix() + acceptor.getURL() + url)));
                }
            }
            return new SLResponse(((Object)urls).toString());
        }
        return new SLResponse(url);
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(GetSharedFileUrlDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

