/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractDropBoxOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class EvictDropBoxOperation
extends AbstractDropBoxOperation<RuntimeContext> {
    public static final String NAME = "evict dropbox";

    public EvictDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction(NAME);
        this.syntax.addModifier(((BlockModifier)new BlockModifier("").setName("namesblock")).addModifier((AbstractModifier)new RepeatableModifier("itemrepeatable").addModifier(new CompoundModifier("rejectitem").addParameter(new IdentifierParameter("dropBoxName")).addModifier(new CompoundModifier("AT_NODE_COMP").addModifier(new AtModifier("AT_NODE")).addParameter(new IdentifierParameter("nodeName"))))));
        this.syntax.setDescription("Eviction of orphan items, removes these items from dropboxes table and mark them as EVICTED on owner node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        StatementBlockValue block = statement.getBlock("namesblock");
        for (StatementValueList line : block.getLines()) {
            String dropBoxName = line.getParameter("dropBoxName").getValue();
            String dropBoxNodeName = line.getParameter("nodeName").getValue();
            ((RuntimeContext)this.callable).getDropBoxManagerRemote().getDropBoxTableManager().evictDropBoxItem(dropBoxName, dropBoxNodeName, session.getOwnerName());
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(EvictDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

