/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.dropbox.AbstractDescribeDropBoxOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractDropBoxOperation;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class EnableDropBoxOperation
extends AbstractDropBoxOperation<RuntimeContext> {
    public static final String NAME = "enable dropbox";

    public EnableDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ENABLE DROPBOX");
        this.addNameAtNodeNameParameter(new AbstractDescribeDropBoxOperation.DropBoxNameAdviser(true));
        this.syntax.setDescription("Enables specified drop box.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invokeDropBox(((Definition)statement).statement, session, timeout);
    }

    @Override
    protected SLResponse invokeRemote(DSLStatement statement, MFSession session, long timeout, String dropBoxName, String nodeName) throws Exception {
        return this.invokeRemote(new Definition(statement), session, timeout, nodeName);
    }

    @Override
    protected SLResponse invokeLocal(DSLStatement statement, MFSession session, long timeout, String dropBoxName) throws Exception {
        try {
            DropBox dropBox = ((RuntimeContext)this.callable).getDropBoxManagerRemote().lookupDropBox(dropBoxName);
            if (dropBox == null) {
                throw new Exception("DropBox '" + dropBoxName + "' doesn't exist.");
            }
            DropBoxUtils.checkUserAccess(dropBox, session.getOwnerName(), DropBoxAccessControlOperation.FULL);
            ((RuntimeContext)this.callable).getDropBoxManagerRemote().enable(dropBox.getName());
            return new SLResponse();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            throw exception;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(EnableDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

