/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.dropbox.AbstractDescribeDropBoxOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractDropBoxOperation;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class DisableDropBoxOperation
extends AbstractDropBoxOperation<RuntimeContext> {
    public static final String NAME = "disable dropbox";

    public DisableDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DISABLE DROPBOX");
        this.addNameAtNodeNameParameter(new AbstractDescribeDropBoxOperation.DropBoxNameAdviser(false));
        this.syntax.setDescription("Disables specified drop box.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invokeDropBox(((Definition)statement).statement, session, timeout);
    }

    @Override
    protected SLResponse invokeRemote(DSLStatement statement, MFSession session, long timeout, String dropBoxName, String nodeName) throws Exception {
        return this.invokeRemote(new Definition(statement), session, timeout, nodeName);
    }

    @Override
    protected SLResponse invokeLocal(DSLStatement statement, MFSession session, long timeout, String dropBoxName) throws Exception {
        DropBox dropBox = ((RuntimeContext)this.callable).getDropBoxManagerRemote().lookupDropBox(dropBoxName);
        if (dropBox == null) {
            throw new Exception("DropBox '" + dropBoxName + "' doesn't exist.");
        }
        DropBoxUtils.checkUserAccess(dropBox, session.getOwnerName(), DropBoxAccessControlOperation.FULL);
        ((RuntimeContext)this.callable).getDropBoxManagerRemote().disable(dropBox.getName());
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(DisableDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

