/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.ds.lib.DataspaceDateTime;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.runtime.mf.operation.dropbox.ListSharedFilesDropBoxOperation;
import com.streamscape.runtime.mf.operation.dropbox.UnshareFileDropBoxOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.AbstractDropBoxConnectionOperation;
import com.streamscape.sef.dropbox.dsl.DropBoxPathParameter;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxSharedResources;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.stream.Collectors;

public class DescribeSharedFileDropBoxOperation
extends AbstractDropBoxConnectionOperation {
    public static final String NAME = "describe shared file";

    public DescribeSharedFileDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SHARED FILE").addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("FILE_CHOICE").addModifier((AbstractModifier)new Modifier("BY RESOURCE ID").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("resource Id").setName("resourceId")).setCompletionAdviser(new UnshareFileDropBoxOperation.SharedFileResoucesIdCompleter())))).addModifier((AbstractModifier)new Modifier("BY PATH").addParameter((SyntaxParameter)((StringParameter)new DropBoxPathParameter("resource path").setName("resourcePath")).setEndDelimiterToCommandEnd())));
        this.syntax.setDescription("Describes shared file corresponding to specified resource ID or specified path.");
        this.syntax.addTag("share");
    }

    protected String getParameterName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxName();
    }

    protected String getParameterNodeName(DSLStatement statement) {
        return ((DropBoxConnectionService)this.callable).getDropBoxAccessor().getDropBox().getNodeName();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    protected SLResponse onInvoke(SLStatement definition, MFSession session, DropBoxConnectionService callable, DropBoxAccessor accessor) throws Exception {
        DSLStatement statement = ((Definition)definition).statement;
        String resourceId = statement.getParameter("resourceId").getValue();
        String resourcePath = statement.getParameter("resourcePath").getValue();
        DropBox dropBox = accessor.getDropBox();
        boolean isOwner = DropBoxUtils.isOwner(dropBox, session.getOwnerName());
        boolean isAdmin = DropBoxUtils.isAdmin(this.getRuntimeContext(), session.getOwnerName());
        if (resourceId != null) {
            DropBoxSharedResources.DropBoxSharedResource resource = dropBox.getSharedResources().getResourceById(resourceId);
            if (resource == null || !isOwner && !isAdmin && !resource.getUsername().equalsIgnoreCase(session.getOwnerName())) {
                throw new DropBoxException("Resource with ID " + resourceId + " not found or no permissions.");
            }
            RowSet rowSet = new RowSet(new RowMetaData().addColumn("Property", String.class).addColumn("Value", String.class));
            rowSet.addToRowSet(new Object[]{"Resource Path", resource.getPath()});
            rowSet.addToRowSet(new Object[]{"Resource ID", resource.getResourceId()});
            rowSet.addToRowSet(new Object[]{"Share Method", resource.getShareMethod().name()});
            rowSet.addToRowSet(new Object[]{"Username", resource.getUsername()});
            rowSet.addToRowSet(new Object[]{"Expires On", resource.getExpiresAt() > 0L ? DataspaceDateTime.trimMills(DescribeSharedFileDropBoxOperation.formatDateMillis(resource.getExpiresAt())) : "never"});
            rowSet.addToRowSet(new Object[]{"Created On", DataspaceDateTime.trimMills(DescribeSharedFileDropBoxOperation.formatDateMillis(resource.getCreatedAt()))});
            rowSet.addToRowSet(new Object[]{"URL", DropBoxSharedResources.buildSharedResourceUrl(dropBox.getName(), resource)});
            try (FileSystem fileSystem = accessor.createFileSystem(session.getOwnerName(), DropBoxAccessor.DropBoxPathNotation.FOLDERS);){
                if (fileSystem.exists(resource.getPath())) {
                    rowSet.addToRowSet(new Object[]{"File Exists", "true"});
                    FileInfo fileInfo = fileSystem.getInfo(resource.getPath());
                    rowSet.addToRowSet(new Object[]{"File Size", SizeUnit.convertToBestFractional(fileInfo.getSize(), SizeUnit.BYTES)});
                } else {
                    rowSet.addToRowSet(new Object[]{"File Exists", "false"});
                }
            }
            return new SLResponse(rowSet);
        }
        return new SLResponse(ListSharedFilesDropBoxOperation.listSharedFiles(dropBox.getSharedResources().getResourceIdsByPath(resourcePath).stream().map(id -> dropBox.getSharedResources().getResourceById((String)id)).collect(Collectors.toList()), dropBox, this.getRuntimeContext(), session));
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(DescribeSharedFileDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

