/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.Trace;
import com.streamscape.lib.fs.client.local.LocalFileSystemClientConnection;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtModifier;
import com.streamscape.runtime.mf.operation.acceptor.AlterAcceptorOperation;
import com.streamscape.runtime.mf.operation.factory.DescribeConnectionFactoryOperation;
import com.streamscape.runtime.mf.operation.factory.ListConnectionFactoriesOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractDropBoxOperation;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxACL;
import com.streamscape.sef.dropbox.sdo.DropBoxACLBind;
import com.streamscape.sef.dropbox.sdo.DropBoxACLContext;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.sef.network.http.server.dropbox.FolderType;
import com.streamscape.sef.security.User;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.modifier.SetModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.SizeUnitParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.parameter.TimeUnitParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CreateDropBoxOperation
extends AbstractDropBoxOperation<RuntimeContext> {
    public static final String NAME = "create dropbox";
    public static String DROPBOX_CREATE_ALTER_DESCRIPTION = "Creates or alters Dropbox and its root folders. More than one folder can be specified in a single command.\n \nFolders are created with access for Upload, Download or Full capability to allow creation of sub-folders\nby users. You may also disable folders without removing their content. This can be useful if access to\ncontent needs to be temporarily disabled for specific owners.\n \nQuotas can set size limitations on files and folders. Retention period may be specified. However the\ncontent is not currently removed, simply marked as expired. A retention of 0 means do not expire content.\n \nA folder with UPLOAD access allows users to create sub-folders. Folders that are for DOWNLOAD do not\nallow users to create sub-folders.\n \nAccess Control Lists can be set to allow for shared or group permissions on folder and sub-folder content in\naddition to standard file creation privileges. Removing a folder with DELETE flag will also remove all of its\ncontents from disk.\n \nNote that Dropbox resources may be accessed and used by Filespace Collections and referenced in RPL\nas well as queries. So check and validate references when moving or altering Dropboxes.\n\nDropbox Folders are considered file system mount points and may be defined with security permissions\nand backed by different storage medium such as native File System, S3 or Hadoop.  As such they can\nonly be defined using CREATE and ALTER commands within a Dropbox.\n \nInside a dropbox folder users can create directories and work with files using typical file system commands\nsuch as CD, LS, COPY and DELETE.  Directories are distinct from Folders because they adopt the security\nsettings of the folder mount point and are used strictly to organize information.  Folders may be defined\nas hierarchies with distinct permissions and may point to different underlying storage media.\n\nUpload and Download permissions are set at the level of Resource Folders only. Meaning, you can add Resource Folders with specific\noperational permissions to a Drop Box. This allows users to configure virtual file systems with fine-grained operational permissions that\nmap to complex hierarchies in underlying storage systems.  Resource Folder permissions only apply to Download and Upload operations against\na Drop Box. For example, you can GRANT write permissions on a Resource Folder that is for Download only and allow a specific user or group\nto add files to the folder's contents using fileWrite(.) functions, File Table or Directory Table operations.\n\nAccess Control can be set at the level of Drop Box or Resource Folder and controls overall ability of a user to modify DropBox contents.\nFor example you can specify general access to Drop Box contents as Full, but then set a specific Resource Folder to be only for Download.\nIn this case the Access lets users modify the root level DropBox contents but not the contents of a specific Resource Folder. Furthermore,\nif PUBLIC ACL permissions are granted, users or groups will have the same read/write (and upload/download) capabilities as those of the \nResource Folder. They are also limited to using File operations such as read or write according to Upload or Download permissions. However,\nACL permissions can alter access control for specific users or groups.\n\nGranting ACL permissions supersedes the general Access permissions of a Resource Folder. For example a folder that has Download Access may\nbe given WRITE access for a specific user. This will allow that user to write and Upload content to a folder that is for Download. This\nallows owners to delegate content management to specific users or groups. ACL permissions apply strictly to Resource Folder content.\n\nUser permissions:\n   PUBLIC  - user can only read/write and list on DropBox directories according to directories access\n   FULL    - user can do everything with DropBox like the owner\n   WRITE   - user can write to any folder in DropBox regardless on it's type\n   READ    - user can read from any folder in DropBox regardless on it's type\n   LIST    \u2013 user can get list of files in DropBox\n\nFS\n\nAllows user to specify which File System (Connection Factory) is used by this DropBox. This value cannot be changed once a dropbox is established.\n\nCurrently there are two File System types supported. Local File System, managed by the Sysplex - which extends to any node in the domain,\nand AWS S3 - which uses the AWS CLI interface and profiles to access the Simple Storage Services (S3) file system. \n\nThe FS parameter can specify a default FSClient.Local parameter to point to the local File Server. Alternatively if a Connection Factory\nfor AWS is created, the File System parameter can point to this configuration. For example AWS.MyFactory can be used if such a factory has\nbeen created.\n\nPlease note that for AWS Dropbox Paths the full URL must be used starting with s3://<bucketname>[/<location>]\n\nPlease see CREATE AWS CONNECTION FACTORY and related commands to understand how access to AWS resources is configured.\n\nDropbox Notifications for GET, PUT and DELETE operations will work for all File System types as long as operations are performed via the\nData Fabric's client.  Native OS changes to any drop box content cannot generate File Server Notifications. However listing contents of a\nDropbox and comparing them via Dropbox commands or Directory Tables can allow users to easily create mechanisms for monitoring remote file\nsystem changes.\n\nAll substitution macros can be used as root folder path names:\n\n   $gvar:(mypool.myvar)\n   $system:(myvar)\n";

    public CreateDropBoxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CREATE DROPBOX").addActionParameter(new IdentifierParameter("name")).addModifier((AbstractModifier)new CompoundModifier("AT_COMPOUND").addModifier(new AtModifier("PATH_AT")).addParameter(new LocalPathParameter("path")).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)new Modifier("OWNER", false).addParameter((SyntaxParameter)new IdentifierParameter("owner").setCompletionAdviser(new AlterAcceptorOperation.UserCompletionAdviser())));
        this.syntax.addModifier(CreateDropBoxOperation.createFoldersBlock("FOLDER", "create", false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FS CLIENT").addParameter((SyntaxParameter)new DescribeConnectionFactoryOperation.ConnectionFactoryTypeNameParameter().setCompletionAdviser(new DropBoxFsClientFactoryCompletionAdviser()))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)CreateDropBoxOperation.createAclBlock("USERS ACL", "usersacl", false, new AlterAcceptorOperation.UserCompletionAdviser()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)CreateDropBoxOperation.createAclBlock("GROUPS ACL", "groupsacl", false, new AlterAcceptorOperation.GroupCompletionAdviser()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new Modifier("ENABLE").setRequired(false));
        this.syntax.setDescription(DROPBOX_CREATE_ALTER_DESCRIPTION + "\n\nDropbox created in the node which connected to the sysplex, becomes available from any node in this sysplex.\nDropbox owner has full access to the folders. Admin users have access to all dropboxes. Dropbox owner can grant\naccess to other users or groups.");
        this.syntax.setExamples("create dropbox mys3box at 's3://mybucketname/mybucketpath'\n    folder(folder1 path 'folder1' access full, folder2 path 'folder2' access upload)\n    fs client AWS.Default\n    enable\n\ncreate dropbox mylocalbox at './mylocaldropboxpath'\n    folder(folder1 path 'folder1' access full, folder2 path 'folder2' access upload)\n    enable\n\ncreate dropbox mylocalbox at '$system:(EVN_VAR)'\n    folder(folder1 path 'folder1' access full, folder2 path 'folder2' access upload)\n    enable\n\n");
    }

    public static BlockModifier createFoldersBlock(String modifier, String postfixName, boolean alter) {
        CompoundModifier foldersLine = new CompoundModifier("foldersline" + postfixName);
        foldersLine.addModifier(new CompoundModifier("NAME_" + postfixName).addParameter((AbstractParameter)new IdentifierParameter("name").setName("folder name" + postfixName)));
        foldersLine.addModifier((AbstractModifier)((Modifier)new Modifier("PATH", "PATH_" + postfixName).addParameter((SyntaxParameter)new StringParameter("folder path").setName("folder path" + postfixName))).setRequired(!alter));
        foldersLine.addModifier((AbstractModifier)((Modifier)new Modifier("ACCESS").addParameter((SyntaxParameter)new EnumParameter("folder type").addPossibleValues("upload", "download", "full", "disabled").setName("folder type" + postfixName))).setRequired(!alter));
        foldersLine.addModifier((AbstractModifier)((BlockModifier)CreateDropBoxOperation.createAclBlock("USERS ACL", "usersacl" + postfixName, false, new AlterAcceptorOperation.UserCompletionAdviser()).setRequired(false)).setSyntaxHint(new SyntaxHint("  ", true)));
        foldersLine.addModifier((AbstractModifier)((BlockModifier)CreateDropBoxOperation.createAclBlock("GROUPS ACL", "groupsacl" + postfixName, false, new AlterAcceptorOperation.GroupCompletionAdviser()).setRequired(false)).setSyntaxHint(new SyntaxHint("  ", true)));
        foldersLine.addModifier(((CompoundModifier)((CompoundModifier)new CompoundModifier("QUOTAS_COMP").setRequired(false)).setSyntaxHint(new SyntaxHint("  ", true))).addModifier(new Modifier("QUOTAS")).addModifier(new SetModifier("QUOTAS_SET").addModifier((AbstractModifier)new CompoundModifier("FILE_SIZE_COMP").addModifier((AbstractModifier)new Modifier("FILE SIZE").addParameter((SyntaxParameter)new LongParameter("size").setName("fileSizeLimit" + postfixName))).addParameter((AbstractParameter)new SizeUnitParameter().setName("fileSizeLimitUnit" + postfixName)).setRequired(false)).addModifier((AbstractModifier)new CompoundModifier("FILE_SIZE_COMP").addModifier((AbstractModifier)new Modifier("FOLDER SIZE").addParameter((SyntaxParameter)new LongParameter("size").setName("folderSizeLimit" + postfixName))).addParameter((AbstractParameter)new SizeUnitParameter().setName("folderSizeLimitUnit" + postfixName)).setRequired(false)).addModifier((AbstractModifier)new CompoundModifier("RETENTION_COMP").addModifier((AbstractModifier)new Modifier("RETENTION").addParameter((SyntaxParameter)new LongParameter("0 means never expire").setName("expiration" + postfixName))).addParameter((AbstractParameter)new TimeUnitParameter().setName("expirationUnit" + postfixName)).setRequired(false))));
        return ((BlockModifier)new BlockModifier(modifier).setName(postfixName)).addModifier((AbstractModifier)new RepeatableModifier("foldersLineRepeatable" + postfixName).addModifier(foldersLine));
    }

    public static BlockModifier createAclBlock(String modifier, String postfixName, boolean alter, CompletionAdviser<RuntimeContext> completionAdviser) {
        CompoundModifier aclLine = new CompoundModifier("aclline" + postfixName);
        aclLine.addParameter((AbstractParameter)((IdentifierParameter)new IdentifierParameter("name").setCompletionAdviser(completionAdviser)).setName("nameValue"));
        aclLine.addModifier((AbstractModifier)new Modifier("acl").addParameter(new SetParameter("aclset", (AbstractParameter)new EnumParameter("acl", DropBoxAccessControlOperation.class).setName("aclValue"))));
        return ((BlockModifier)new BlockModifier(modifier).setName(postfixName)).addModifier((AbstractModifier)new RepeatableModifier("foldersLineRepeatable" + postfixName).addModifier(aclLine));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        try {
            DSLStatement statement = ((Definition)definition).statement;
            User user = ((RuntimeContext)this.callable).getSecurityManager().lookupUser(session.getOwnerName());
            if (!user.isDropBoxOwner()) {
                throw new DropBoxException("User '" + session.getOwnerName() + "' is not DropBox owner.");
            }
            String owner = statement.getParameter("owner").getValue(null);
            if (owner != null) {
                if (!owner.equalsIgnoreCase(session.getOwnerName())) {
                    if (!user.isAdministrator()) {
                        throw new Exception("Only admin user can set DropBox owner.");
                    }
                    if (!((RuntimeContext)this.callable).getSecurityManager().existsUser(owner)) {
                        throw new Exception("Specified owner user '" + owner + "' doesn't exist.");
                    }
                }
            } else {
                owner = session.getOwnerName();
            }
            DropBox dropBox = new DropBox(statement.getParameter("name").getValue());
            dropBox.setRootFolder(statement.getParameter("path").getValue());
            if (statement.existsParameter("FactoryType")) {
                dropBox.setFsClientFactory(statement.getParameter("FactoryType").getValue() + "." + statement.getParameter("FactoryName").getValue());
            }
            DropBoxACLContext acl = new DropBoxACLContext();
            CreateDropBoxOperation.fillAcl(statement, acl, "");
            dropBox.setAclContext(acl);
            dropBox.setEnabled(statement.existsModifier("ENABLE"));
            dropBox.setOwner(owner);
            StatementBlockValue block = statement.getBlock("create");
            if (block != null) {
                for (StatementValueList line : block.getLines()) {
                    dropBox.addFolder(CreateDropBoxOperation.createFolder(dropBox, line, "create"));
                }
            }
            ((RuntimeContext)this.callable).getDropBoxManagerRemote().addDropBox(dropBox);
            return new SLResponse();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            throw exception;
        }
    }

    public static void fillAcl(StatementValueList statement, DropBoxACLContext acl, String postfix) {
        StatementBlockValue block = statement.getBlock("usersacl" + postfix);
        if (block != null) {
            for (StatementValueList line : block.getLines()) {
                CreateDropBoxOperation.addAcl(line, acl.getUsers());
            }
        }
        acl.getUsers().removeEmptyAcls();
        block = statement.getBlock("groupsacl" + postfix);
        if (block != null) {
            for (StatementValueList line : block.getLines()) {
                CreateDropBoxOperation.addAcl(line, acl.getGroups());
            }
        }
        acl.getGroups().removeEmptyAcls();
    }

    private static void addAcl(StatementValueList line, DropBoxACLBind aclBind) {
        StatementSetValue set = line.getSet("aclset");
        DropBoxACL acl = new DropBoxACL();
        List<DropBoxAccessControlOperation> acls = set.getElements().stream().map(e -> DropBoxAccessControlOperation.valueOf(e.getParameter("aclValue").getValue().toUpperCase())).collect(Collectors.toList());
        acl.add(acls.toArray(new DropBoxAccessControlOperation[0]));
        aclBind.setAcl(line.getParameter("nameValue").getValue(), acl);
    }

    public static DropBoxFolder createFolder(DropBox dropBox, StatementValueList line, String postfix) {
        String folderName = line.getParameter("folder name" + postfix).getValue().trim();
        String folderPath = line.getParameter("folder path" + postfix).getValue().trim();
        if (folderPath.length() == 0) {
            folderPath = ".";
        }
        return CreateDropBoxOperation.fillFolder(dropBox, line, postfix, new DropBoxFolder(folderName, folderPath));
    }

    public static DropBoxFolder fillFolder(DropBox dropBox, StatementValueList line, String postfix, DropBoxFolder folder) {
        folder.setType(FolderType.parse(line.getParameter("folder type" + postfix).getValue(folder.getType() != null ? folder.getType().name() : null).toUpperCase()));
        StatementSetValue quotasSet = line.getSet("QUOTAS_SET");
        for (StatementValueList element : quotasSet.getElements()) {
            if (element.existsParameter("fileSizeLimit" + postfix)) {
                folder.setFileSizeLimit(element.getParameter("fileSizeLimit" + postfix).getValue(0));
                folder.setFileSizeLimitUnit(SizeUnitParameter.parseValue(element.getParameter("fileSizeLimitUnit" + postfix).getValue()));
                continue;
            }
            if (element.existsParameter("folderSizeLimit" + postfix)) {
                folder.setFolderSizeLimit(element.getParameter("folderSizeLimit" + postfix).getValue(0));
                folder.setFolderSizeLimitUnit(SizeUnitParameter.parseValue(element.getParameter("folderSizeLimitUnit" + postfix).getValue()));
                continue;
            }
            if (!element.existsParameter("expiration" + postfix)) continue;
            folder.setExpiration(element.getParameter("expiration" + postfix).getValue(0));
            folder.setExpirationUnit(TimeUnitParameter.parseValue(element.getParameter("expirationUnit" + postfix).getValue()));
        }
        DropBoxACLContext acl = new DropBoxACLContext();
        CreateDropBoxOperation.fillAcl(line, acl, postfix);
        if (!acl.getUsers().getAcl("admin").isEmpty() && !acl.getUsers().getAcl("admin").isAllowed(DropBoxAccessControlOperation.FULL) || !acl.getGroups().getAcl("admin").isEmpty() && !acl.getGroups().getAcl("admin").isAllowed(DropBoxAccessControlOperation.FULL) || !acl.getUsers().getAcl(dropBox.getOwner()).isEmpty() && !acl.getUsers().getAcl(dropBox.getOwner()).isAllowed(DropBoxAccessControlOperation.FULL)) {
            throw new DropBoxException("ACLs for admin or DropBox owner cannot be changed.");
        }
        acl.getUsers().setAcl("admin", new DropBoxACL());
        acl.getGroups().setAcl("Admins", new DropBoxACL());
        acl.getUsers().setAcl(dropBox.getOwner(), new DropBoxACL());
        acl.getUsers().removeEmptyAcls();
        acl.getGroups().removeEmptyAcls();
        folder.setAclFolderContext(acl);
        return folder;
    }

    public static class DropBoxFsClientFactoryCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            ArrayList<String> result = new ArrayList<String>();
            try {
                RepositoryAccessor repositoryAccessor = callable.getRepositoryAccessor();
                for (String fullname : ListConnectionFactoriesOperation.listConnectionFactories(callable, ListConnectionFactoriesOperation.FactoryScope.CLIENT, false)) {
                    try {
                        ClientFactory factory;
                        String type;
                        String name = ModeratorUtils.extractComponentNameName(fullname);
                        if (!repositoryAccessor.existsClientFactory(name, type = ModeratorUtils.extractComponentNameType(fullname)) || !(factory = repositoryAccessor.loadClientFactory(name, type)).getConnectionClassName().equals(LocalFileSystemClientConnection.class.getName()) && !factory.getConnectionClassName().contains("FileSystem")) continue;
                        result.add(fullname);
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to process factory " + fullname + ". Cause: " + exception.getMessage());
                    }
                }
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to get list of factories. Cause: " + exception.getMessage());
            }
            result.add(DropBox.LOCAL_FACTORY);
            result.add(DropBox.STFS_FACTORY);
            return result;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private final DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(CreateDropBoxOperation.NAME);
            this.statement = statement;
        }

        public DSLStatement getStatement() {
            return this.statement;
        }
    }
}

