/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.dropbox.AbstractDescribeDropBoxOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractDropBoxOperation;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxACL;
import com.streamscape.sef.dropbox.sdo.DropBoxACLBind;
import com.streamscape.sef.dropbox.sdo.DropBoxACLContext;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AbstractGrantRevokeDropBoxOperation<T extends SLCallable>
extends AbstractDropBoxOperation<T> {
    public static final String DROPBOX_GRANT_DESCRIPTION = "Grant/revoke permissions of specified dropbox or dropbox folder.";
    private boolean grant;

    public AbstractGrantRevokeDropBoxOperation(boolean inDropbox, boolean grant) {
        this.grant = grant;
        this.createDSLSyntax(this.getOperationName());
        this.syntax.setAction(this.getOperationName());
        if (!inDropbox) {
            this.addNameAtNodeNameParameter(new AbstractDescribeDropBoxOperation.DropBoxNameAdviser(null));
        }
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOLDER").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("name").setName("folderName")).setCompletionAdviser(new AbstractDescribeDropBoxOperation.DropBoxFolderNameAdviser(this.getOperationName())))).setRequired(false));
        this.syntax.addModifier(new ChoiceModifier("PERMISSION_CHOICE").addPossibleValues(DropBoxAccessControlOperation.class));
        this.syntax.addModifier(((CompoundModifier)new CompoundModifier().setSyntaxHintSpace()).addModifier(new Modifier(grant ? "TO" : "FROM")).addParameter((AbstractParameter)new IdentifierParameter("Grantee").setCompletionAdviser(new UserGroupCompletionAdviser())));
        if (inDropbox) {
            this.syntax.setDescription(DROPBOX_GRANT_DESCRIPTION);
        } else {
            this.syntax.setDescription("Grant/revoke permissions of specified dropbox or dropbox folder.\n\nIf there is only one DropBox with specified name in the Sysplex, this DropBox will be altered.\nIf there are several DropBoxes with specified name, node name should be specified.");
        }
    }

    private String getOperationName() {
        return (this.grant ? "GRANT" : "REVOKE") + " DROPBOX";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getOperationName(), statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        return this.invokeDropBox(((Definition)definition).statement, session, timeout);
    }

    @Override
    protected SLResponse invokeRemote(DSLStatement statement, MFSession session, long timeout, String dropBoxName, String nodeName) throws Exception {
        return this.invokeRemote(new Definition(this.getOperationName(), statement), session, timeout, nodeName);
    }

    @Override
    protected SLResponse invokeLocal(DSLStatement statement, MFSession session, long timeout, String dropBoxName) throws Exception {
        String grantee = statement.getParameter("Grantee").getValue();
        boolean isUser = this.getRuntimeContext().getSecurityManager().existsUser(grantee);
        boolean isGroup = this.getRuntimeContext().getSecurityManager().existsGroup(grantee);
        if (!isUser && !isGroup) {
            throw new DropBoxException("Invalid user/group specified.");
        }
        Consumer<DropBox> updateFunction = dropBox -> {
            DropBoxUtils.checkUserAccess(dropBox, session.getOwnerName(), DropBoxAccessControlOperation.FULL);
            DropBoxFolder folder = null;
            if (statement.existsParameter("folderName") && (folder = dropBox.getFolderByName(statement.getParameter("folderName").getValue())) == null) {
                throw new DropBoxException("Folder '" + statement.getParameter("folderName").getValue() + "' does not exist.");
            }
            DropBoxACLContext aclContext = folder != null ? folder.getAclFolderContext() : dropBox.getAclContext();
            DropBoxAccessControlOperation operation = DropBoxAccessControlOperation.valueOf(statement.getModifier("PERMISSION_CHOICE").getToken());
            DropBoxACLBind bind = isUser ? aclContext.getUsers() : aclContext.getGroups();
            DropBoxACL acl = bind.getAcl(grantee);
            if (this.grant) {
                acl.add(operation);
            } else {
                acl.remove(operation);
            }
            bind.setAcl(grantee, acl);
            bind.removeEmptyAcls();
            if (folder != null) {
                folder.setAclFolderContext(aclContext);
            } else {
                dropBox.setAclContext(aclContext);
            }
        };
        this.getRuntimeContext().getDropBoxManagerRemote().updateDropBox(dropBoxName, updateFunction);
        if (this.grant) {
            this.grantUseOn(session, grantee);
        }
        return new SLResponse();
    }

    private void grantUseOn(MFSession session, String grantee) throws Exception {
        SecurityManager securityManager = this.getSecurityManager(session);
        securityManager.addUserPermission(grantee, AccessControlOperation.CONNECTION_FACTORY_USE);
    }

    public static class UserGroupCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            try {
                ArrayList<String> result = new ArrayList<String>();
                result.addAll(callable.getSecurityManager().getUsers().stream().map(u -> u.getName().toString()).collect(Collectors.toList()));
                result.addAll(callable.getSecurityManager().getGroups().stream().map(g -> g.getName().toString()).collect(Collectors.toList()));
                return result;
            }
            catch (SecurityManagerException e) {
                return Collections.emptyList();
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(String name, DSLStatement statement) {
            super(name);
            this.statement = statement;
        }
    }
}

