/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.Trace;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.lib.utils.CIString;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractDropBoxOperation;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxConnectionService;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.dsl.LsDropBoxOperation;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxACL;
import com.streamscape.sef.dropbox.sdo.DropBoxACLContext;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.lexer.BufferUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AbstractDescribeDropBoxOperation<T extends SLCallable>
extends AbstractDropBoxOperation<T> {
    public static final String NAME = "describe dropbox";

    public AbstractDescribeDropBoxOperation(boolean inDropbox) {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE DROPBOX");
        if (!inDropbox) {
            this.addNameAtNodeNameParameter(new DropBoxNameAdviser());
        }
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("CHOICE_").setRequired(false)).addModifier(new Modifier("FOLDERS"))).addModifier(new CompoundModifier("FOLDER_ACL_COMPOUND").addModifier((AbstractModifier)new Modifier("FOLDER").addParameter((SyntaxParameter)((IdentifierParameter)new IdentifierParameter("name").setName("folderName")).setCompletionAdviser(new DropBoxFolderNameAdviser(NAME)))).addModifier((AbstractModifier)new Modifier("ACL").setName("FOLDERACL")))).addModifier(new Modifier("ACL"))).addModifier(new Modifier("RESOURCES")));
        this.syntax.setDescription("Returns properties for specified dropbox.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invokeDropBox(((Definition)statement).statement, session, timeout);
    }

    @Override
    protected SLResponse invokeRemote(DSLStatement statement, MFSession session, long timeout, String dropBoxName, String nodeName) throws Exception {
        return this.invokeRemote(new Definition(statement), session, timeout, nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SLResponse invokeLocal(DSLStatement statement, MFSession session, long timeout, String dropBoxName) throws Exception {
        RowSet rowSet;
        boolean isOwnerOrFull;
        DropBox dropBox;
        DropBox dropBox2 = dropBox = this.callable instanceof RuntimeContext ? ((RuntimeContext)this.callable).getDropBoxManager().lookupDropBox(dropBoxName) : ((DropBoxConnectionService)this.callable).getDropBoxAccessor().getDropBox();
        if (dropBox == null) {
            throw new Exception("Drop Box with specified name doesn't exist.");
        }
        DropBoxUtils.checkUserAccess(dropBox, session.getOwnerName(), DropBoxAccessControlOperation.LIST);
        boolean bl = isOwnerOrFull = DropBoxUtils.isOwner(dropBox, session.getOwnerName()) || DropBoxUtils.hasUserAccess(dropBox, session.getOwnerName(), DropBoxAccessControlOperation.FULL);
        if (statement.existsModifier("FOLDERS") || statement.existsModifier("RESOURCES")) {
            rowSet = new RowSet(new RowMetaData().addColumn("Name", String.class).addColumn("Path", String.class).addColumn("Type", String.class).addColumn("Permissions", String.class).addColumn("Size On Disk", String.class).addColumn("File Size Limit", String.class).addColumn("Folder Size Limit", String.class).addColumn("Expiration", String.class));
            DropBoxAccessor accessor = null;
            String sizeOnDisk = "n/a";
            try {
                accessor = this.callable instanceof RuntimeContext ? ((RuntimeContext)this.callable).getDropBoxManager().createDropBoxAccessor(dropBox.getName()) : ((DropBoxConnectionService)this.callable).getDropBoxAccessor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try (FileSystem fileSystem = null;){
                if (accessor != null) {
                    fileSystem = accessor.createFileSystem(session.getOwnerName(), DropBoxAccessor.DropBoxPathNotation.OS);
                }
                for (DropBoxFolder dropBoxFolder : dropBox.getFolders()) {
                    sizeOnDisk = this.getSizeOnDisk(fileSystem, dropBoxFolder.getPath());
                    LsDropBoxOperation.DropBoxResourceType type = LsDropBoxOperation.DropBoxResourceType.UNKNOWN;
                    if (fileSystem != null) {
                        try {
                            FileInfo info;
                            type = fileSystem.exists(dropBoxFolder.getPath()) ? ((info = fileSystem.getInfo(dropBoxFolder.getPath())).isDirectory() ? LsDropBoxOperation.DropBoxResourceType.MANAGED_RESOURCE : LsDropBoxOperation.DropBoxResourceType.MISSING_RESOURCE) : LsDropBoxOperation.DropBoxResourceType.MISSING_RESOURCE;
                        }
                        catch (Exception exception) {
                            Trace.logException(this, exception, true);
                        }
                    }
                    rowSet.addToRowSet(new Object[]{dropBoxFolder.getName(), isOwnerOrFull ? dropBoxFolder.getPath() : Character.valueOf('-'), type.getValue(), dropBoxFolder.getType().getNameForDescribe(), sizeOnDisk, dropBoxFolder.getFileSizeLimitString(), dropBoxFolder.getFolderSizeLimitString(), dropBoxFolder.getExpirationString()});
                }
                if (!statement.existsModifier("RESOURCES")) return new SLResponse(rowSet);
                List directories = fileSystem.list(".").stream().filter(i -> i.isDirectory()).filter(i -> dropBox.getFolders().stream().filter(f -> DropBoxUtils.normalizePath(f.getPath()).equalsIgnoreCase(DropBoxUtils.normalizePath(i.getName()))).count() == 0L).collect(Collectors.toList());
                for (FileInfo directory : directories) {
                    rowSet.addToRowSet(new Object[]{"-", directory.getName(), LsDropBoxOperation.DropBoxResourceType.UNMANAGED_RESOURCE.getValue(), "-", this.getSizeOnDisk(fileSystem, directory.getName()), "", "", ""});
                }
                return new SLResponse(rowSet);
            }
        }
        if (statement.existsModifier("ACL")) {
            rowSet = new RowSet(new RowMetaData().addColumn("Type", String.class).addColumn("Name", String.class).addColumn("ACL", String.class));
            rowSet.addToRowSet(new Object[]{"user", dropBox.getOwner(), "[" + DropBoxAccessControlOperation.FULL.toString() + "]"});
            rowSet.addToRowSet(new Object[]{"group", "Admins", "[" + DropBoxAccessControlOperation.FULL.toString() + "]"});
            DropBoxACLContext aclContext = dropBox.getAclContext();
            for (Map.Entry<CIString, DropBoxACL> entry : aclContext.getUsers().getMap().entrySet()) {
                if (entry.getKey().equals(dropBox.getOwner())) continue;
                rowSet.addToRowSet(new Object[]{"user", entry.getKey().toString(), entry.getValue().getOperations().toString()});
            }
            for (Map.Entry<CIString, DropBoxACL> entry : aclContext.getGroups().getMap().entrySet()) {
                if (entry.getKey().equals("Admins")) continue;
                rowSet.addToRowSet(new Object[]{"group", entry.getKey().toString(), entry.getValue().getOperations().toString()});
            }
            return new SLResponse(rowSet);
        }
        if (statement.existsModifier("FOLDERACL")) {
            rowSet = new RowSet(new RowMetaData().addColumn("Type", String.class).addColumn("Name", String.class).addColumn("ACL", String.class));
            rowSet.addToRowSet(new Object[]{"user", dropBox.getOwner(), "[" + DropBoxAccessControlOperation.FULL.toString() + "]"});
            rowSet.addToRowSet(new Object[]{"group", "Admins", "[" + DropBoxAccessControlOperation.FULL.toString() + "]"});
            String folderName = statement.getParameter("folderName").getValue();
            DropBoxFolder folder = dropBox.getFolderByName(folderName);
            if (folder == null) {
                throw new Exception("Folder with name '" + folderName + "' does not exist.");
            }
            DropBoxACLContext aclContext = folder.getAclFolderContext();
            for (Map.Entry<CIString, DropBoxACL> entry : aclContext.getUsers().getMap().entrySet()) {
                rowSet.addToRowSet(new Object[]{"user", entry.getKey().toString(), entry.getValue().getOperations().toString()});
            }
            for (Map.Entry<CIString, DropBoxACL> entry : aclContext.getGroups().getMap().entrySet()) {
                rowSet.addToRowSet(new Object[]{"group", entry.getKey().toString(), entry.getValue().getOperations().toString()});
            }
            return new SLResponse(rowSet);
        }
        rowSet = new RowSet(new RowMetaData().addColumn("Property", String.class).addColumn("Value", String.class));
        DropBoxAccessor accessor = null;
        String sizeOnDisk = "n/a";
        try {
            accessor = this.callable instanceof RuntimeContext ? ((RuntimeContext)this.callable).getDropBoxManager().createDropBoxAccessor(dropBox.getName()) : ((DropBoxConnectionService)this.callable).getDropBoxAccessor();
            try (FileSystem fileSystem = accessor.createFileSystem(session.getOwnerName(), DropBoxAccessor.DropBoxPathNotation.OS);){
                sizeOnDisk = this.getSizeOnDisk(fileSystem, ".");
            }
        }
        catch (Exception fileSystem) {
            // empty catch block
        }
        boolean isOwner = DropBoxUtils.isOwner(dropBox, session.getOwnerName());
        boolean isAdmin = DropBoxUtils.isAdmin(this.getRuntimeContext(), session.getOwnerName());
        rowSet.addToRowSet(new Object[]{"Name", dropBox.getName()});
        Object[] objectArray = new Object[2];
        objectArray[0] = "Root Folder";
        objectArray[1] = isAdmin ? (DropBoxUtils.isS3Path(dropBox.getRootFolder()) ? dropBox.getRootFolder() : new File(dropBox.getRootFolder()).getAbsolutePath().toString()) : (isOwner ? dropBox.getRootFolder() : "****");
        rowSet.addToRowSet(objectArray);
        rowSet.addToRowSet(new Object[]{"FS Client Factory", dropBox.getFsClientFactory()});
        rowSet.addToRowSet(new Object[]{"Folders Count", dropBox.getFolders().size()});
        rowSet.addToRowSet(new Object[]{"Owner", dropBox.getOwner()});
        rowSet.addToRowSet(new Object[]{"Node", dropBox.getNodeName()});
        rowSet.addToRowSet(new Object[]{"Enabled", dropBox.isEnabled()});
        rowSet.addToRowSet(new Object[]{"Size On Disk", sizeOnDisk});
        rowSet.addToRowSet(new Object[]{"Acceptors", DropBoxUtils.listAcceptorsForDropBox(RuntimeContext.getInstance(), dropBox.getName()).stream().collect(Collectors.joining(","))});
        rowSet.addToRowSet(new Object[]{"Status", dropBox.isEnabled() && (accessor == null || accessor.isError()) ? "ERROR" : "OK"});
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "Last Error";
        objectArray2[1] = dropBox.isEnabled() ? (accessor == null ? "Accessor is null." : (accessor.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(accessor.getException()) : "")) : "";
        rowSet.addToRowSet(objectArray2);
        rowSet.addToRowSet(new Object[]{"Path Notation", this.callable instanceof DropBoxConnectionService ? ((DropBoxConnectionService)this.callable).getDropBoxPathNotation().toString() : DropBoxAccessor.DropBoxPathNotation.FOLDERS.toString()});
        return new SLResponse(rowSet);
    }

    private String getSizeOnDisk(FileSystem fileSystem, String path) {
        try {
            FileInfo rootInfo = fileSystem.getInfo(path);
            if (rootInfo.getSize() > 0L) {
                return SizeUnit.convertToBestFractional(rootInfo.getSize(), SizeUnit.BYTES).toStringWithPrecision(2);
            }
            return "n/a";
        }
        catch (Exception exception) {
            return "n/a";
        }
    }

    public static class DropBoxNameAdviser
    implements CompletionAdviser<RuntimeContext> {
        private Boolean enabled;

        public DropBoxNameAdviser() {
        }

        public DropBoxNameAdviser(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            if (this.enabled == null) {
                return callable.getDropBoxManagerRemote().listDropBoxesVisibleBy(session.getOwnerName());
            }
            HashSet result = new HashSet(callable.getDropBoxManagerRemote().listDropBoxesVisibleBy(session.getOwnerName()).stream().filter(name -> this.enabled ^ callable.getDropBoxManagerRemote().isEnabled((String)name)).collect(Collectors.toList()));
            result.addAll(callable.getDropBoxManager().listDropBoxesVisibleBy(session.getOwnerName()).stream().filter(name -> this.enabled ^ callable.getDropBoxManagerRemote().isEnabled((String)name)).collect(Collectors.toList()));
            return new ArrayList<String>(result);
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class DropBoxFolderNameAdviser
    implements CompletionAdviser<Object> {
        private String commandName;

        public DropBoxFolderNameAdviser(String commandName) {
            this.commandName = commandName;
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, Object callable, MFSession session) {
            DropBox dropBox = null;
            if (callable instanceof RuntimeContext) {
                if ((processedScript = BufferUtils.normalizeCommand(processedScript)).toLowerCase().startsWith(this.commandName.toLowerCase())) {
                    String name = processedScript.substring(this.commandName.length()).trim();
                    if (name.indexOf(" ") != -1) {
                        name = name.substring(0, name.indexOf(" ")).trim();
                    }
                    dropBox = ((RuntimeContext)callable).getDropBoxManager().lookupDropBox(name);
                }
            } else if (callable instanceof DropBoxConnectionService) {
                dropBox = ((DropBoxConnectionService)callable).getDropBoxAccessor().getDropBox();
            }
            ArrayList<String> result = new ArrayList<String>();
            if (dropBox != null) {
                result.addAll(dropBox.getFolders().stream().map(f -> f.getName()).collect(Collectors.toList()));
            }
            return result;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(AbstractDescribeDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

