/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dropbox;

import com.streamscape.lib.fs.client.FileSystem;
import com.streamscape.runtime.mf.operation.acceptor.AlterAcceptorOperation;
import com.streamscape.runtime.mf.operation.dropbox.AbstractDescribeDropBoxOperation;
import com.streamscape.runtime.mf.operation.dropbox.CreateDropBoxOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractDropBoxOperation;
import com.streamscape.sef.dropbox.DropBoxAccessor;
import com.streamscape.sef.dropbox.DropBoxUtils;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.dropbox.sdo.DropBoxACL;
import com.streamscape.sef.dropbox.sdo.DropBoxACLContext;
import com.streamscape.sef.dropbox.sdo.DropBoxAccessControlOperation;
import com.streamscape.sef.dropbox.sdo.DropBoxFolder;
import com.streamscape.sef.network.http.server.dropbox.DropBoxException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class AbstractAlterDropBoxOperation<T extends SLCallable>
extends AbstractDropBoxOperation<T> {
    public static final String NAME = "alter dropbox";

    public AbstractAlterDropBoxOperation(boolean inDropbox) {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER DROPBOX");
        if (!inDropbox) {
            this.addNameAtNodeNameParameter(new AbstractDescribeDropBoxOperation.DropBoxNameAdviser(null));
        }
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("SET NAME").addParameter((SyntaxParameter)new IdentifierParameter("new name").setName("dropBoxNameNew"))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)new Modifier("SET OWNER", false).addParameter((SyntaxParameter)new IdentifierParameter("owner").setCompletionAdviser(new AlterAcceptorOperation.UserCompletionAdviser())));
        this.syntax.addModifier((AbstractModifier)CreateDropBoxOperation.createFoldersBlock("ADD FOLDER", "create", false).setRequired(false));
        this.syntax.addModifier((AbstractModifier)CreateDropBoxOperation.createFoldersBlock("SET FOLDER", "alter", true).setRequired(false));
        this.syntax.addModifier(((CompoundModifier)new CompoundModifier("DROP_COMPO").addModifier(new CompoundModifier("REMOVE_FOLD_COMP").addModifier(new Modifier("REMOVE FOLDER")).addParameter(((SetParameter)new SetParameter("folders").setName("drop")).addParameter((AbstractParameter)new IdentifierParameter("folder name").setName("folderName")))).setRequired(false)).addModifier((AbstractModifier)((Modifier)new Modifier("DELETE").setName("withContent")).setRequired(false)));
        this.syntax.addModifier((AbstractModifier)CreateDropBoxOperation.createAclBlock("SET USERS ACL", "usersacl", true, new AlterAcceptorOperation.UserCompletionAdviser()).setRequired(false));
        this.syntax.addModifier((AbstractModifier)CreateDropBoxOperation.createAclBlock("SET GROUPS ACL", "groupsacl", true, new AlterAcceptorOperation.GroupCompletionAdviser()).setRequired(false));
        if (inDropbox) {
            this.syntax.setDescription(CreateDropBoxOperation.DROPBOX_CREATE_ALTER_DESCRIPTION);
        } else {
            this.syntax.setDescription(CreateDropBoxOperation.DROPBOX_CREATE_ALTER_DESCRIPTION + "\n\nIf there is only one DropBox with specified name in the Sysplex, this DropBox will be altered.\nIf there are several DropBoxes with specified name, node name should be specified.");
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        return this.invokeDropBox(((Definition)definition).statement, session, timeout);
    }

    @Override
    protected SLResponse invokeRemote(DSLStatement statement, MFSession session, long timeout, String dropBoxName, String nodeName) throws Exception {
        return this.invokeRemote(new Definition(statement), session, timeout, nodeName);
    }

    @Override
    protected SLResponse invokeLocal(DSLStatement statement, MFSession session, long timeout, String dropBoxName) throws Exception {
        Consumer<DropBox> updateFunction = dropBox -> {
            DropBoxUtils.checkUserAccess(dropBox, session.getOwnerName(), DropBoxAccessControlOperation.FULL);
            String dropBoxNameNew = statement.getParameter("dropBoxNameNew").getValue(null);
            if (dropBoxNameNew != null) {
                if (dropBox.isEnabled()) {
                    throw new DropBoxException("DropBox should be disabled to change its name.");
                }
                if (this.getRuntimeContext().getDropBoxManager().lookupDropBox(dropBoxNameNew) != null) {
                    throw new DropBoxException("DropBox with specified new name '" + dropBoxNameNew + "' already exist.");
                }
                Set nodes = this.getRuntimeContext().getDropBoxManagerRemote().getDropBoxTableManager().getDropBoxTable().listDropBoxTableItemsSortedDesc(dropBoxNameNew).stream().map(i -> i.getDropBoxNodeName()).collect(Collectors.toSet());
                if (nodes.size() > 0) {
                    throw new DropBoxException("DropBox with specified new name '" + dropBoxNameNew + "' already exist in node" + (nodes.size() > 1 ? "s " : " ") + String.valueOf(nodes));
                }
            }
            DropBoxACLContext aclContext = dropBox.getAclContext();
            aclContext.getUsers().setAcl("admin", new DropBoxACL());
            aclContext.getGroups().setAcl("Admins", new DropBoxACL());
            aclContext.getUsers().setAcl(dropBox.getOwner(), new DropBoxACL());
            aclContext.getUsers().removeEmptyAcls();
            aclContext.getGroups().removeEmptyAcls();
            CreateDropBoxOperation.fillAcl(statement, aclContext, "");
            if (!(aclContext.getUsers().getAcl("admin").isEmpty() && aclContext.getGroups().getAcl("admin").isEmpty() && aclContext.getUsers().getAcl(dropBox.getOwner()).isEmpty())) {
                throw new DropBoxException("ACLs for admin or DropBox owner cannot be changed.");
            }
            dropBox.setAclContext(aclContext);
            if (statement.existsSet("drop")) {
                StatementSetValue dropFolders = statement.getSet("drop");
                boolean withContent = statement.existsModifier("withContent");
                for (StatementValueList element : dropFolders.getElements()) {
                    DropBoxFolder folder;
                    String folderName = element.getParameter("folderName").getValue();
                    if (withContent && (folder = dropBox.getFolderByName(folderName)) != null) {
                        DropBoxAccessor accessor = this.getRuntimeContext().getDropBoxManagerRemote().createDropBoxAccessor(dropBox.getName());
                        try {
                            try (FileSystem fileSystem = accessor.createFileSystem(session.getOwnerName(), DropBoxAccessor.DropBoxPathNotation.OS);){
                                fileSystem.delete(folder.getPath(), true);
                            }
                            finally {
                                accessor.close();
                            }
                        }
                        catch (Exception exception) {
                            throw new DropBoxException("os failed", exception);
                        }
                    }
                    dropBox.removeFolderByName(folderName);
                }
            }
            if (statement.existsBlock("alter")) {
                StatementBlockValue alterFolders = statement.getBlock("alter");
                for (StatementValueList line : alterFolders.getLines()) {
                    String folderName = line.getParameter("folder namealter").getValue("name");
                    DropBoxFolder folder = dropBox.getFolderByName(folderName);
                    if (folder == null) {
                        String folderPath = line.getParameter("folder pathalter").getValue("name");
                        if (folderPath == null) {
                            throw new DropBoxException("Folder path is not set for folder " + folderName);
                        }
                        folder = CreateDropBoxOperation.fillFolder(dropBox, line, "alter", new DropBoxFolder(folderName, folderPath));
                        dropBox.addFolder(folder);
                        continue;
                    }
                    CreateDropBoxOperation.fillFolder(dropBox, line, "alter", folder);
                }
            }
            if (statement.existsBlock("create")) {
                StatementBlockValue createFolders = statement.getBlock("create");
                for (StatementValueList line : createFolders.getLines()) {
                    DropBoxFolder folder = CreateDropBoxOperation.createFolder(dropBox, line, "create");
                    if (dropBox.getFolderByName(folder.getName()) != null) {
                        folder = dropBox.getFolderByName(folder.getName());
                        CreateDropBoxOperation.fillFolder(dropBox, line, "create", folder);
                        continue;
                    }
                    dropBox.addFolder(folder);
                }
            }
            if (statement.existsParameter("owner")) {
                if (!session.getOwner().isAdministrator()) {
                    throw new DropBoxException("Only administrator user can change owner of DropBox account.");
                }
                dropBox.setOwner(statement.getParameter("owner").getValue());
            }
        };
        this.getRuntimeContext().getDropBoxManagerRemote().updateDropBox(dropBoxName, updateFunction);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        public Definition(DSLStatement statement) {
            super(AbstractAlterDropBoxOperation.NAME);
            this.statement = statement;
        }
    }
}

