/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.discovery.DiscoveryModuleConfiguration;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ShowDiscoveryOperation
extends AbstractDiscoveryOperation {
    public static final String NAME = "show discovery";

    public ShowDiscoveryOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW DISCOVERY");
        this.syntax.setDescription("Shows information about the active Discovery Module.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ShowDiscoveryOperation.createResultDescriptor());
        DiscoveryModuleConfiguration configuration = ((RuntimeContext)this.callable).getDiscoveryModuleFactory().getActiveModuleConfiguration();
        result.addToRowSet(new Object[]{"Name", configuration.getName()});
        result.addToRowSet(new Object[]{"Description", configuration.getDescription()});
        result.addToRowSet(new Object[]{"Class", configuration.getModuleClass()});
        for (String parameterName : configuration.listParameters()) {
            result.addToRowSet(new Object[]{parameterName, configuration.getParameter(parameterName)});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ShowDiscoveryOperation.addColumn(result, "Name");
        ShowDiscoveryOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ShowDiscoveryOperation.NAME);
        }
    }
}

