/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class ShowDirectoryTableOperation
extends AbstractDiscoveryOperation {
    public static final String NAME = "show directory table";

    public ShowDirectoryTableOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW DIRECTORY TABLE ");
        this.syntax.addModifier(new CompoundModifier("AsFormat", false).addModifier(new Modifier("AS")).addModifier(new ChoiceModifier("Format").addPossibleValues("XML", "JSON")));
        this.syntax.setDescription("show directory table - Shows the Directory Table in the specified format (default format is XML).\n\nOptional parameters:\n\n   as xml  - Shows the table in XML format.\n   as json - Shows the table in JSON format.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("XML"), statement.existsModifier("JSON"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ShowDirectoryTableOperation.createResultDescriptor());
        DirectoryTable table = this.getDirectoryTable();
        if (definition.asXML) {
            result.addToRowSet(new Object[]{table.asXML()});
        } else if (definition.asJSON) {
            result.addToRowSet(new Object[]{table.asJSON()});
        } else {
            result.addToRowSet(new Object[]{table});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ShowDirectoryTableOperation.addColumn(result, "Directory Table");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private boolean asXML = false;
        private boolean asJSON = false;

        public Definition(boolean asXML, boolean asJSON) {
            super(ShowDirectoryTableOperation.NAME);
            this.asXML = asXML;
            this.asJSON = asJSON;
        }

        public boolean isAsXML() {
            return this.asXML;
        }

        public boolean isAsJSON() {
            return this.asJSON;
        }
    }
}

