/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.discovery.DiscoveryModuleConfiguration;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import java.util.HashMap;
import java.util.Map;

public class SetDiscoveryPropertiesOperation
extends AbstractDiscoveryOperation {
    public static final String NAME = "set discovery properties";

    public SetDiscoveryPropertiesOperation() {
        super(true, false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET DISCOVERY PROPERTIES");
        this.syntax.addModifier((AbstractModifier)new SetParametersModifier("", "Properties").setSyntaxHintSpace());
        this.syntax.setDescription("Sets the specified configuration properties of the active Discovery Module.");
        this.syntax.setSyntaxDescription("Default Discovery Module supports the following parameters:\n\n   fabricDirectory       - Path to file containing the Directory Table.\n                           If this file exists the module replaces the current Directory Table.\n   multicastEnabled      - Enables or disables multicast (UDP) discovery.\n                           Multicast response contains all links of the current Directory Table.\n   multicastWaitingTime  - Wait time (in seconds) of multicast response.\n                           If the time is negative (< 0) the module does not wait for multicast responses.\n   multicastAddress      - Address (host:port) on which the module listens multicast requests.\n   multicastUseAcceptors - Enables or disables a use of node acceptors in multicast response.");
        this.syntax.setExamples("set discovery properties (fabricDirectory = 'DirectoryTable.xdo')\nset discovery properties (multicastEnabled = 'true', multicastWaitingTime = '1', multicastAddress = '230.0.0.0:8889')");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(SetParametersModifier.getValue(statement, "Properties"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        DiscoveryModuleConfiguration configuration = ((RuntimeContext)this.callable).getDiscoveryModuleFactory().getActiveModuleConfiguration();
        for (Map.Entry<String, String> entry : ((Definition)statement).properties.entrySet()) {
            configuration.setParameter(entry.getKey(), entry.getValue());
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private Map<String, String> properties;

        public Definition(Map<String, String> properties) {
            super(SetDiscoveryPropertiesOperation.NAME);
            this.properties = properties;
        }

        public Map<String, String> getProperties() {
            return new HashMap<String, String>(this.properties);
        }
    }
}

