/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class RemoveFdsNodeOperation
extends AbstractDiscoveryOperation {
    public static final String NAME = "remove fds node";

    public RemoveFdsNodeOperation() {
        super(true, false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE FDS NODE").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.setDescription("Removes the specified discovery node from the Directory Table");
        this.syntax.setExamples("remove fds node TestNode");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        DirectoryTable table = this.getDirectoryTable();
        if (!table.existsNode(definition.nodeName)) {
            return new SLResponse("Discovery node '" + definition.nodeName + "' not found.", false);
        }
        table.removeNode(definition.nodeName);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;

        public Definition(String nodeName) {
            super(RemoveFdsNodeOperation.NAME);
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

