/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class RemoveFdsLinkOperation
extends AbstractDiscoveryOperation {
    public static final String NAME = "remove fds link";

    public RemoveFdsLinkOperation() {
        super(true, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE FDS LINK");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FROM", false).addParameter((SyntaxParameter)new IdentifierParameter("SourceNode").addExclusionValue("TO"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO").addParameter(new IdentifierParameter("TargetNode"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Removes the specified discovery link from the Directory Table.\nIf the parameter <SourceNode> is not specified, the current node is used as a source node.\n");
        this.syntax.setExamples("remove fds link from TestNode1 to TestNode2\nremove fds link to TestNode2");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("SourceNode") ? statement.getParameter("SourceNode").getValue() : null, statement.getParameter("TargetNode").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.getDirectoryTable().removeLink(definition.sourceNode != null ? definition.sourceNode : ((RuntimeContext)this.callable).getName(), new DiscoveryLink(definition.targetNode, null));
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String sourceNode;
        private String targetNode;

        public Definition(String sourceNode, String targetNode) {
            super(RemoveFdsLinkOperation.NAME);
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
        }

        public String getSourceNode() {
            return this.sourceNode;
        }

        public String getTargetNode() {
            return this.targetNode;
        }
    }
}

