/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListFdsNodesOperation
extends AbstractDiscoveryOperation {
    public static final String NAME = "list fds nodes";

    public ListFdsNodesOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction(NAME);
        this.syntax.setDescription("Shows a list of all discovery nodes in the Directory Table");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListFdsNodesOperation.createResultDescriptor());
        for (DirectoryTable.Node node : this.getDirectoryTable().getAllNodes()) {
            result.addToRowSet(new Object[]{node.getName(), node.getRole() != null ? node.getRole() : ""});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListFdsNodesOperation.addColumn(result, "Node");
        ListFdsNodesOperation.addColumn(result, "Role");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListFdsNodesOperation.NAME);
        }
    }
}

