/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.exchange.TopologyLink;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import java.util.List;

public class ListFdsLinksOperation
extends AbstractDiscoveryOperation {
    public static final String NAME = "list fds links";

    public ListFdsLinksOperation() {
        super(false, true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction(NAME);
        this.syntax.addModifier((AbstractModifier)new AtNodeOrAtDomainModifier().setSyntaxHintSpace());
        this.syntax.setDescription("list fds links                - Returns a list of all discovery links for the current node.\nlist fds links at node <Node> - Returns a list of all discovery links for the specified node.\nlist fds links at domain      - Returns a list of all discovery links for all nodes of the sysplex.");
        this.syntax.setExamples("list fds links\nlist fds links at node Node1\nlist fds links at domain");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String nodeName;
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ListFdsLinksOperation.createResultDescriptor());
        String string = nodeName = definition.nodeName != null ? definition.nodeName : ((RuntimeContext)this.callable).getName();
        if (nodeName.equals("*")) {
            List<TopologyLink> topology = ((RuntimeContext)this.callable).getExchange().getTopology();
            for (DirectoryTable.Node node : this.getDirectoryTable().getAllNodes()) {
                this.addNode(node, topology, result);
            }
        } else {
            DirectoryTable.Node node = this.getDirectoryTable().getNode(nodeName);
            if (node == null) {
                return new SLResponse("Discovery node '" + nodeName + "' not found.", false);
            }
            this.addNode(node, ((RuntimeContext)this.callable).getExchange().getTopology(), result);
        }
        return new SLResponse(result);
    }

    private void addNode(DirectoryTable.Node node, List<TopologyLink> topology, RowSet result) throws Exception {
        for (DiscoveryLink link : node.getLinks()) {
            result.addToRowSet(new Object[]{node.getName(), link.getNodeName(), link.getLinkAddress().toString(), link.isBackup(), topology.contains(new TopologyLink(node.getName(), link.getNodeName(), link.getLinkAddress()))});
        }
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListFdsLinksOperation.addColumn(result, "Source Node");
        ListFdsLinksOperation.addColumn(result, "Target Node");
        ListFdsLinksOperation.addColumn(result, "Access Point");
        ListFdsLinksOperation.addColumn(result, "Backup");
        ListFdsLinksOperation.addColumn(result, "Active");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;

        public Definition(String nodeName) {
            super(ListFdsLinksOperation.NAME);
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

