/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.mf.operation.discovery.AbstractDiscoveryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.discovery.DirectoryTable;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;

public class AddFdsNodeOperation
extends AbstractDiscoveryOperation {
    public static final String NAME = "add fds node";

    public AddFdsNodeOperation() {
        super(true, false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD FDS NODE").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("ROLE").addParameter(new EnumParameter("Role").addPossibleValue(FabricNodeRole.MANAGEMENT_NODE.name()).addPossibleValue(FabricNodeRole.TASK_NODE.name()))).setRequired(false)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Adds an empty discovery node with the specified parameters to the Directory Table");
        this.syntax.setExamples("add fds node TestNode role TASK_NODE");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue(), statement.existsModifier("ROLE") ? FabricNodeRole.valueOf(statement.getParameter("Role").getValue()) : null);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        DirectoryTable table = this.getDirectoryTable();
        if (table.existsNode(definition.nodeName)) {
            return new SLResponse("Discovery node '" + definition.nodeName + "' already exists.", false);
        }
        table.addNode(definition.nodeName, definition.role);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private FabricNodeRole role;

        public Definition(String nodeName, FabricNodeRole role) {
            super(AddFdsNodeOperation.NAME);
            this.nodeName = nodeName;
            this.role = role;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public FabricNodeRole getRole() {
            return this.role;
        }
    }
}

