/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.discovery;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.dispatcher.AbstractAddFdsLinkOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class AddFdsLinkOperation
extends AbstractAddFdsLinkOperation {
    public static final String NAME = "add fds link";

    public AddFdsLinkOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD FDS LINK");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FROM", false).addParameter((SyntaxParameter)new IdentifierParameter("SourceNode").addExclusionValue("TO"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO").addParameter(new IdentifierParameter("TargetNode"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("AT").setAlias("@")).addParameter(new StringParameter("URL"))).setSyntaxHintSpace());
        this.syntax.addModifier(new Modifier("AS BACKUP", false));
        this.syntax.addModifier((AbstractModifier)new Modifier("ATTACH", false).setSyntaxHintSpace());
        this.syntax.setDescription("Adds a discovery link with the specified URL to the Directory Table.");
        this.syntax.setSyntaxDescription("If the parameter <SourceNode> is not specified, the current node is used as a source node.\nURL must have the following format: [tlp(s)://]<host>.<port> (e.g. tlp://localhost:5000 or 127.0.0.1:5000).\nAlso URL can use global variables and macros.\n\nParameters:\n\n   as backup - Adds the backup link (used if all primary links are not accessible).\n               First link of the node cannot be backup.\n   attach    - Attaches the current node to the sysplex.\n               This parameter is only applicable to the current node.");
        this.syntax.setExamples("add fds link from TestNode1 to TestNode2 at 'localhost:5000'\nadd fds link to TestNode2 at 'localhost:5000'\nadd fds link to TestNode2 at 'tlp://$gvar:(Node1_1.tlp_host):$gvar:(Node1_1.tlp_port)'\nadd fds link to TestNode2 at 'localhost:5000' attach");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("SourceNode") ? statement.getParameter("SourceNode").getValue() : null, statement.getParameter("TargetNode").getValue(), statement.getParameter("URL").getValue(), statement.existsModifier("AS BACKUP") ? Boolean.valueOf(true) : null, statement.existsModifier("ATTACH"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        String sourceNodeName = definition.sourceNode != null ? definition.sourceNode : ((RuntimeContext)this.callable).getName();
        FabricNodeReference sourceNode = ((RuntimeContext)this.callable).getModerator().lookupFabricNode(sourceNodeName);
        FabricNodeRole sourceNodeRole = sourceNode != null ? sourceNode.getRole() : FabricNodeRole.TASK_NODE;
        this.getDirectoryTable().addLink(sourceNodeName, sourceNodeRole, new DiscoveryLink(definition.targetNode, definition.url, definition.backup));
        if (definition.attach) {
            if (sourceNode == null || !sourceNode.isLocal()) {
                throw new FabricException("Only the current node can be attached to the sysplex.");
            }
            this.doAttach();
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String sourceNode;
        private String targetNode;
        private String url;
        private Boolean backup;
        private boolean attach;

        public Definition(String sourceNode, String targetNode, String url, Boolean backup, boolean attach) {
            super(AddFdsLinkOperation.NAME);
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            this.url = url;
            this.backup = backup;
            this.attach = attach;
        }

        public String getSourceNode() {
            return this.sourceNode;
        }

        public String getTargetNode() {
            return this.targetNode;
        }

        public String getURL() {
            return this.url;
        }

        public Boolean isBackup() {
            return this.backup;
        }

        public boolean isAttach() {
            return this.attach;
        }
    }
}

