/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dataspace;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.dataspace.AbstractDataspaceOperation;
import com.streamscape.runtime.mf.operation.dataspace.DropDataspaceOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.EnumSet;

public class StartDataspaceOperation
extends AbstractDataspaceOperation {
    public static final String NAME = "start dataspace";

    public StartDataspaceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("START DATASPACE").addModifier(new AbstractDataspaceOperation.DataspaceName(new DropDataspaceOperation.DataspaceCompletionAdviser(EnumSet.of(ComponentState.STOPPED, ComponentState.DESTROYED)), ""));
        this.syntax.setDescription("Starts the specified dataspace.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AbstractDataspaceOperation.DataspaceName.getDataspaceName(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ((RuntimeContext)this.callable).getDataspaceManager().initDataspace(((Definition)statement).getCollectionName(), session.getOwnerName());
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String collectionName;

        public Definition(String name) {
            super(StartDataspaceOperation.NAME);
            this.collectionName = name;
        }

        public String getCollectionName() {
            return this.collectionName;
        }
    }
}

