/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dataspace;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.dataspace.AbstractDataspaceOperation;
import com.streamscape.runtime.mf.operation.dataspace.DropDataspaceOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.EnumSet;

public class OnlineDataspaceOperation
extends AbstractDataspaceOperation {
    public static final String NAME = "online dataspace";

    public OnlineDataspaceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ONLINE DATASPACE").addModifier(new AbstractDataspaceOperation.DataspaceName(new DropDataspaceOperation.DataspaceCompletionAdviser(EnumSet.of(ComponentState.NOT_INITIALIZED, ComponentState.DESTROYED, ComponentState.STOPPED, ComponentState.INITIALIZED)), ""));
        this.syntax.setDescription("Makes the specified dataspace online.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AbstractDataspaceOperation.DataspaceName.getDataspaceName(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ((RuntimeContext)this.callable).getDataspaceManager().openDataspace(((Definition)statement).getDataspaceName(), session.getOwnerName());
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String dataspaceName;

        public Definition(String name) {
            super(OnlineDataspaceOperation.NAME);
            this.dataspaceName = name;
        }

        public String getDataspaceName() {
            return this.dataspaceName;
        }
    }
}

