/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dataspace;

import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.core.DataspaceStoreState;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AbstractListServicesDataspacesOperation;
import com.streamscape.runtime.mf.operation.moderator.AbstractNodeOperation;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class ListDataspacesOperation
extends AbstractListServicesDataspacesOperation {
    public static final String NAME = "list dataspaces";
    private static final Pattern MODEL_PATTERN = Pattern.compile(".*[$].*");

    public ListDataspacesOperation() {
        super(NAME);
        this.syntax.addTag(OperationTag.dataspace);
    }

    @Override
    protected void addSelectionModifiers() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(ListDataspacesOperation.createAllModifier())).addModifier(new CompoundModifier().addModifier(new Modifier("AND", false)).addModifier(new Modifier("MODEL"))));
    }

    @Override
    protected String getEntityName() {
        return "dataspace";
    }

    @Override
    protected String getTypeForExamples() {
        return "tspace";
    }

    @Override
    protected AbstractParameter createTypeParameter() {
        return new EnumParameter("Type", DataspaceType.class, DataspaceType.FSPACE, DataspaceType.QSPACE, DataspaceType.TSPACE, DataspaceType.CSPACE);
    }

    @Override
    protected String getSelectionParametersDescription() {
        return "   model       - Returns a list of model dataspaces (whose name ends in $&lt;Model&gt; pattern.)\n   and model   - Returns a list of user dataspaces and model dataspaces.\n";
    }

    @Override
    protected String getLikeParameterDescription(String entitiesName) {
        return super.getLikeParameterDescription(entitiesName) + "                 If the parameter 'model' is specified, the pattern is applied to the model (part of the name after the $ sign).\n";
    }

    @Override
    protected String getOtherExamples() {
        return "\nlist dataspaces model\nlist dataspaces and model\nlist dataspaces model like '%History'\nlist dataspaces and model like '%History'";
    }

    @Override
    protected void fillResult(AbstractListServicesDataspacesOperation.Definition definition, MFSession session, Pattern pattern, RowSet result) throws Exception {
        for (DataspaceComponent component : this.getDataspaces()) {
            if (!this.isSuitable(component.getType(), component.getName(), component.getEventScope(), definition, session, pattern)) continue;
            ListDataspacesOperation.addValues(result, ((RuntimeContext)this.callable).getName(), component.getType(), component.getName(), component.getEventScope().toString(), ListDataspacesOperation.getDataspaceStateString(component));
        }
    }

    public static String getDataspaceStateString(DataspaceComponent component) {
        ComponentState componentState = component.getState();
        DataspaceStoreState dataspaceState = null;
        if (componentState == ComponentState.STARTED || componentState == ComponentState.STOPPED || componentState == ComponentState.INITIALIZED) {
            dataspaceState = (DataspaceStoreState)((Object)((AbstractDataspace)component).aggregateDataspaceState().getState());
        }
        return ListDataspacesOperation.getDataspaceStateString(componentState, dataspaceState);
    }

    public static String getDataspaceStateString(ComponentState componentState, DataspaceStoreState dataspaceState) {
        Object state = null;
        switch (componentState) {
            case NOT_INITIALIZED: 
            case DESTROYED: {
                state = "STOPPED";
                break;
            }
            case DESTROYING: {
                state = "STOPPING";
                break;
            }
            case INITIALIZING: {
                state = "STARTING";
                break;
            }
            case INITIALIZED: {
                state = "OFFLINE";
                break;
            }
            case STARTING: {
                state = "ONLINING";
                break;
            }
            case STOPPING: {
                state = "OFFLINING";
                break;
            }
            case STOPPED: {
                state = "OFFLINE";
                break;
            }
            case STARTED: {
                state = "ONLINE";
                break;
            }
            case PENDING: 
            case SUSPENDING: 
            case SUSPENDED: 
            case RESUMING: 
            case SUSPECT: 
            case OUTSYNC: {
                state = componentState.toString();
            }
        }
        if (dataspaceState == DataspaceStoreState.RECOVERY_FAILED) {
            state = dataspaceState.toString();
        } else if (dataspaceState != null && (componentState == ComponentState.STARTED || componentState == ComponentState.STOPPED || componentState == ComponentState.INITIALIZED) && dataspaceState != DataspaceStoreState.ONLINE) {
            state = (String)state + "(" + dataspaceState.toString() + ")";
        }
        return state;
    }

    @Override
    protected boolean matchesSelection(String type, String name, AbstractListServicesDataspacesOperation.Definition definition, MFSession session) {
        if (definition.modelType == AbstractListServicesDataspacesOperation.ModelType.MODEL) {
            return !this.isSystem(type, name) && this.isModel(name);
        }
        if (definition.modelType == AbstractListServicesDataspacesOperation.ModelType.AND_MODEL) {
            return !this.isSystem(type, name) || this.isModel(name);
        }
        if (definition.all) {
            return ListDataspacesOperation.isAll(true, session) || !this.isSystem(type, name);
        }
        return !this.isSystem(type, name) && !this.isModel(name);
    }

    @Override
    protected boolean matchesPattern(String name, AbstractListServicesDataspacesOperation.Definition definition, Pattern pattern) {
        return definition.modelType != null ? (this.isModel(name) ? super.matchesPattern(name.substring(name.lastIndexOf("$") + 1), definition, pattern) : definition.modelType == AbstractListServicesDataspacesOperation.ModelType.AND_MODEL) : super.matchesPattern(name, definition, pattern);
    }

    @Override
    protected boolean matchesType(String type, AbstractListServicesDataspacesOperation.Definition definition) {
        return definition.type == null || type.equals(definition.type.toUpperCase());
    }

    @Override
    protected boolean isSystem(String type, String name) {
        return AbstractNodeOperation.isSystemComponent(type, name);
    }

    private boolean isModel(String name) {
        return MODEL_PATTERN.matcher(name).matches();
    }

    private List<DataspaceComponent> getDataspaces() {
        List<DataspaceComponent> dataspaces = ((RuntimeContext)this.callable).getDataspaceManager().getDataspaces();
        dataspaces.sort(Comparator.comparing(FabricComponent::getType).thenComparing(FabricComponent::getName));
        return dataspaces;
    }
}

