/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dataspace;

import com.streamscape.ds.NameManager;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.dataspace.AbstractDataspaceOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class DropDataspaceOperation
extends AbstractDataspaceOperation {
    public static final String NAME = "drop dataspace";

    public DropDataspaceOperation() {
        this.createDSLSyntax(NAME);
        ((DSLStatementSyntax)((DSLStatementSyntax)((DSLStatementSyntax)this.syntax.setAction("DROP DATASPACE").addModifier(new AbstractDataspaceOperation.DataspaceName(new DataspaceCompletionAdviser(), ""))).addModifier((AbstractModifier)((Modifier)new Modifier("IF EXISTS").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE))).addModifier((AbstractModifier)((Modifier)new Modifier("CASCADE").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE))).addModifier((AbstractModifier)((Modifier)new Modifier("FORCE").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Drops the specified dataspace.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AbstractDataspaceOperation.DataspaceName.getDataspaceName(statement), statement.existsModifier("IF EXISTS"), statement.existsModifier("CASCADE"), statement.existsModifier("FORCE"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        DataspaceManager dsManager = ((RuntimeContext)this.callable).getDataspaceManager();
        if (definition.ifExists && !dsManager.existsDataspace(definition.dataspaceName)) {
            return new SLResponse();
        }
        Method dropDataspace = ClassUtils.getDeclaredOrInheritedMethod(dsManager.getClass(), "dropDataspace", new Class[]{String.class, User.class, Boolean.class, Boolean.class}, true);
        dropDataspace.setAccessible(true);
        try {
            ClassUtils.invokeMethod(dsManager, dropDataspace, new Object[]{definition.dataspaceName, session.getOwner(), definition.cascade, definition.force});
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof Exception) {
                throw (Exception)exception.getTargetException();
            }
            throw exception;
        }
        return new SLResponse();
    }

    public static class DataspaceCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        private EnumSet<ComponentState> states;

        public DataspaceCompletionAdviser() {
            this(EnumSet.allOf(ComponentState.class));
        }

        public DataspaceCompletionAdviser(EnumSet<ComponentState> states) {
            this.states = states;
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            return callable.getDataspaceManager().getDataspaces().stream().filter(d -> !AbstractDSLOperation.isSystemDataspace(d.getName())).filter(d -> this.states.contains((Object)d.getState())).map(d -> NameManager.quoteName(d.getName())).collect(Collectors.toList());
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String dataspaceName;
        private boolean ifExists;
        private boolean cascade;
        private final boolean force;

        public Definition(String name, boolean ifExists, boolean cascade, boolean force) {
            super(DropDataspaceOperation.NAME);
            this.dataspaceName = name;
            this.ifExists = ifExists;
            this.cascade = cascade;
            this.force = force;
        }

        public String getDataspaceName() {
            return this.dataspaceName;
        }
    }
}

