/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dataspace;

import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.schemaserialization.DumpLoadUtil;
import com.streamscape.ds.utils.schemaserialization.SchemaLoader;
import com.streamscape.runtime.mf.operation.dataspace.AbstractDataspaceOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractRuntimeServiceMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;

public class DescribeDataspaceDumpOperation
extends AbstractDataspaceOperation {
    public static final String NAME = "describe dataspace dump";

    public DescribeDataspaceDumpOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction(NAME.toUpperCase()).addActionParameter(new SLFilePathParameter("FilePath"));
        this.syntax.setDescription("Shows manifest of specified database dump file");
        this.syntax.setInitialVersion("3.8 Build 14");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("FilePath").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String dumpFileName = ((Definition)statement).getFileName();
        Session sdsSession = ((AbstractRuntimeServiceMFSession)session).getDataspaceSDSSession();
        SchemaLoader loader = new SchemaLoader(sdsSession, dumpFileName, false);
        RowSet result = new RowSet(DescribeDataspaceDumpOperation.createResultDescriptor());
        for (Object[] objects : DumpLoadUtil.describeDataspaceColumns(loader)) {
            result.addToRowSet(objects);
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData metaData = new RowMetaData(10);
        DescribeDataspaceDumpOperation.addColumn(metaData, "Name");
        DescribeDataspaceDumpOperation.addColumn(metaData, "Value");
        return metaData;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String fileName;

        public Definition(String name) {
            super(DescribeDataspaceDumpOperation.NAME);
            this.fileName = name;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

