/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dataspace;

import com.streamscape.runtime.mf.operation.dataspace.AbstractCheckDescribeDataspaceOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.lang.DSLStatement;

public class CheckDataspaceOperation
extends AbstractCheckDescribeDataspaceOperation {
    public CheckDataspaceOperation() {
        super(AbstractCheckDescribeDataspaceOperation.Type.CHECK);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = this.createDefinition(statement.getParameter("DataspaceFullName").getValue());
        definition.setMode(statement.getModifier("CHOICE").getToken());
        definition.setStore(statement.getModifier("STORE").isPresent());
        if (definition.isStore() && definition.mode.equalsIgnoreCase("consistency") && definition.dataspaceName.equalsIgnoreCase("force")) {
            definition.mode = "consistency force";
            definition.dataspaceName = "";
        } else if (!definition.isStore() && definition.mode.equalsIgnoreCase("consistency") && definition.dataspaceName.toLowerCase().startsWith("force ")) {
            definition.mode = "consistency force";
            definition.dataspaceName = definition.dataspaceName.substring(4);
        }
        return definition;
    }

    @Override
    protected Definition createDefinition(String dataspaceName) {
        return new Definition(dataspaceName);
    }

    public static class Definition
    extends AbstractCheckDescribeDataspaceOperation.Definition {
        private String mode;

        public Definition(String dataspaceName) {
            super(AbstractCheckDescribeDataspaceOperation.Type.CHECK.getCommand(), dataspaceName);
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }
    }
}

