/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.dataspace;

import com.streamscape.ds.NameManager;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.dataspace.AbstractDataspaceOperation;
import com.streamscape.runtime.mf.operation.dataspace.CheckDataspaceOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetFactory;
import com.streamscape.sef.dispatcher.SLSessionUseOperation;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.User;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCheckDescribeDataspaceOperation
extends AbstractDataspaceOperation {
    public AbstractCheckDescribeDataspaceOperation(Type type) {
        super(type == Type.CHECK);
        this.createDSLSyntax(type.getCommand());
        this.syntax.setAction(type.getCommand().toUpperCase());
        this.syntax.addModifier((AbstractModifier)new Modifier("STORE").setRequired(false));
        if (type == Type.CHECK) {
            this.syntax.addModifier((AbstractModifier)new ChoiceModifier("CHOICE").addPossibleValues("collections", "references", "all", "consistency").setRequired(false));
        }
        this.syntax.addParameter((AbstractParameter)((ExpressionParameter)((ExpressionParameter)new ExpressionParameter("DataspaceFullName").setCompactSyntax("[NodeName://]<DataspaceType>.<DataspaceName>")).setEndDelimiterToCommandEnd()).setCompletionAdviser(new DataspaceCompletionAdviserForCheckDescribe()));
        this.syntax.setDescription(type == Type.CHECK ? "Checks the specified objects or all objects for reference errors or inconsistencies.\nReports the errors if they exist and attempts to fix references if they are discovered, \nby re-compiling functions, actors or triggers and resolving their external references." : "Shows information about the specified dataspace or dataspace store.");
        this.syntax.setExamples((type == Type.CHECK ? "check" : "describe") + " dataspace TSPACE.Employees\n" + (type == Type.CHECK ? "check" : "describe") + " dataspace Node1://TSPACE.Employees\n" + (type == Type.CHECK ? "check" : "describe") + " dataspace collections TSPACE.Employees\n" + (type == Type.CHECK ? "check" : "describe") + " dataspace all TSPACE.Employees\n" + (type == Type.CHECK ? "check" : "describe") + " dataspace store\n" + (type == Type.CHECK ? "check dataspace store consistency\n" : "") + (type == Type.CHECK ? "check dataspace store collections\n" : "") + (type == Type.CHECK ? "check dataspace store references\n" : "") + (type == Type.CHECK ? "check dataspace store all\n" : ""));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.createDefinition(statement.getParameter("DataspaceFullName").getValue());
    }

    protected abstract SLStatement createDefinition(String var1);

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String nodeName = ModeratorUtils.extractNodeName(((Definition)statement).getDataspaceName());
        if (nodeName == null) {
            nodeName = ((RuntimeContext)this.callable).getName();
        }
        return this.invoke(nodeName, statement, session, timeout, false, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        String dataspaceName;
        Definition definition = (Definition)statement;
        SecurityContext securityContext = session.getOwner().getSecurityContext();
        if (securityContext == null) {
            securityContext = new SecurityContext(this, (User)session.getOwner(), null){};
        }
        if ((dataspaceName = definition.getDataspaceName()) == null || dataspaceName.length() == 0) {
            if (definition.store) {
                dataspaceName = "TSAPCE.SDS";
            } else {
                throw new Exception("Dataspace name shuld be specified.");
            }
        }
        try (Connection connection = ((RuntimeContext)this.callable).getDataspaceManager().getJDBCConnection(NameManager.unquoteString(ModeratorUtils.extractComponentNameName(dataspaceName)), securityContext);){
            Statement stm = connection.createStatement();
            Object sql = this.syntax.getName();
            if (definition.store) {
                sql = (String)sql + " store";
            }
            if (definition instanceof CheckDataspaceOperation.Definition) {
                sql = (String)sql + " " + ((CheckDataspaceOperation.Definition)definition).getMode();
            }
            stm.execute((String)sql);
            RowSet rowSet = new RowSetFactory().createRowSet(stm.getResultSet());
            SLResponse sLResponse = new SLResponse(rowSet);
            return sLResponse;
        }
    }

    public static enum Type {
        CHECK("check dataspace"),
        DESCRIBE("describe dataspace");

        private String command;

        private Type(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }

    public static class DataspaceCompletionAdviserForCheckDescribe
    implements CompletionAdviser<RuntimeContext> {
        /*
         * WARNING - void declaration
         */
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            ArrayList<String> result = new ArrayList<String>();
            List<String> nodeNames = callable.getModerator().listFabricNodes();
            for (String nodeName : nodeNames) {
                if (nodeName.equals(callable.getName())) continue;
                FabricNodeReference node = callable.getModerator().lookupFabricNode(nodeName);
                List<String> componentFullNames = node.listComponents();
                for (String string : componentFullNames) {
                    void var12_12;
                    ComponentReference componentReference = callable.getModerator().lookupComponent(string);
                    if (componentReference.getModel() != ComponentModel.DATASPACE) continue;
                    if (script != null && script.length() > 0) {
                        String nodeNamePrefix = nodeName + "://";
                        String prefix = script.trim();
                        if (prefix.length() > nodeNamePrefix.length() && prefix.startsWith(nodeNamePrefix)) {
                            String string2 = nodeNamePrefix + SLSessionUseOperation.buildDataspaceComponentName(componentReference, prefix.substring(nodeNamePrefix.length()));
                        }
                    }
                    result.add((String)var12_12);
                }
            }
            result.add("store");
            return result;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static abstract class Definition
    extends AbstractSLStatement {
        protected String dataspaceName;
        private boolean store;

        public Definition(String name, String dataspaceName) {
            super(name);
            this.dataspaceName = dataspaceName;
        }

        public String getDataspaceName() {
            return this.dataspaceName;
        }

        public void setStore(boolean store) {
            this.store = store;
        }

        public boolean isStore() {
            return this.store;
        }
    }
}

