/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.converter;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.converter.AbstractConverterOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;
import java.util.stream.Collectors;

public class UnregisterConverterOperation
extends AbstractConverterOperation {
    public static final String NAME = "unregister converter";

    public UnregisterConverterOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("UNREGISTER CONVERTER").addActionParameter(new IdentifierParameter("ConverterName"));
        this.syntax.setDescription("Unregisters the specified converter.");
        this.syntax.setExamples("unregister converter ConnStateToEmail");
        this.syntax.addCompletionCommand("list converters");
        this.setPreserveCompletionOrder();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ConverterName").getValue());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getConverterPluginManager().listConverterPlugins().stream().sorted().collect(Collectors.toList()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ((RuntimeContext)this.callable).getConverterPluginManager().unregisterConverterPlugin(((Definition)statement).getConverterName());
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        String converterName;

        public Definition(String name) {
            super(UnregisterConverterOperation.NAME);
            this.converterName = name;
        }

        public String getConverterName() {
            return this.converterName;
        }
    }
}

