/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.converter;

import com.streamscape.omf.mapper.ConverterPluginDescriptor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.converter.AbstractConverterOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;

public class RegisterConverterOperation
extends AbstractConverterOperation {
    public static final String NAME = "register converter";

    public RegisterConverterOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REGISTER CONVERTER").addActionParameter(new IdentifierParameter("ConverterName"));
        this.syntax.addModifier((AbstractModifier)new Modifier("CLASS").addParameter(new IdentifierParameter("ConverterClass")));
        this.syntax.addModifier((AbstractModifier)new Modifier("INBOUND").addParameter(new IdentifierParameter("InboundSemanticType")));
        this.syntax.addModifier((AbstractModifier)new Modifier("OUTBOUND").addParameter(new IdentifierParameter("OutboundSemanticType")));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("Description", Character.valueOf('\''), Character.valueOf('\'')))).setRequired(false));
        this.syntax.setDescription("Registers the specified converter.");
        this.syntax.setExamples("register converter ConnStateToEmail\n  class com.streamscape.converter.ConnStateToEmail\n  inbound ConnectionState\n  outbound MailEvent\n  description 'Converts conn state to email'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ConverterName").getValue(), statement.getParameter("ConverterClass").getValue(), statement.getParameter("InboundSemanticType").getValue(), statement.getParameter("OutboundSemanticType").getValue(), statement.getParameter("Description").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ConverterPluginDescriptor cnvDesc = new ConverterPluginDescriptor(definition.getConverterName(), definition.getClassName());
        cnvDesc.setInboundSemanticType(definition.getInbound());
        cnvDesc.setOutboundSemanticType(definition.getOutbound());
        cnvDesc.setDescription(definition.getDescription());
        ((RuntimeContext)this.callable).getConverterPluginManager().registerConverterPlugin(cnvDesc);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        String converterName;
        String className;
        String inbound;
        String outbound;
        String description;

        public Definition(String name, String className, String inbound, String outbound, String description) {
            super(RegisterConverterOperation.NAME);
            this.converterName = name;
            this.className = className;
            this.inbound = inbound;
            this.outbound = outbound;
            this.description = description;
        }

        public String getConverterName() {
            return this.converterName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getInbound() {
            return this.inbound;
        }

        public String getOutbound() {
            return this.outbound;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

