/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.converter;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.converter.AbstractConverterOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.Collections;
import java.util.List;

public class ListConvertersOperation
extends AbstractConverterOperation {
    public static final String NAME = "list converters";

    public ListConvertersOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST CONVERTERS");
        this.syntax.setDescription("Returns a list of all registered converters in the node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListConvertersOperation.createResultDescriptor());
        List<String> converters = ((RuntimeContext)this.callable).getConverterPluginManager().listConverterPlugins();
        Collections.sort(converters);
        for (String converter : converters) {
            result.addToRowSet(new Object[]{converter});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListConvertersOperation.addColumn(result, "Converter");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListConvertersOperation.NAME);
        }
    }
}

