/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.converter;

import com.streamscape.omf.mapper.ConverterPluginDescriptor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.converter.AbstractConverterOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeConverterOperation
extends AbstractConverterOperation {
    public static final String NAME = "describe converter";

    public DescribeConverterOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE CONVERTER").addActionParameter(new IdentifierParameter("ConverterName"));
        this.syntax.setDescription("Shows information about the specified converter.");
        this.syntax.setExamples("describe converter ConnectionStateToEmail");
        this.syntax.addCompletionCommand("list converters");
        this.setPreserveCompletionOrder();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ConverterName").getValue());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getConverterPluginManager().listConverterPlugins().stream().sorted().collect(Collectors.toList()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ConverterPluginDescriptor descriptor = ((RuntimeContext)this.callable).getConverterPluginManager().getConverterPluginDescriptor(definition.converterName);
        if (descriptor == null) {
            return new SLResponse("Converter plugin not found.", false);
        }
        RowSet result = new RowSet(DescribeConverterOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{"Converter Name", descriptor.getName()});
        result.addToRowSet(new Object[]{"Class Name", descriptor.getPluginClassName()});
        result.addToRowSet(new Object[]{"Inbound Semantic Type", descriptor.getInboundSemanticType()});
        result.addToRowSet(new Object[]{"Outbound Semantic Type", descriptor.getOutboundSemanticType()});
        result.addToRowSet(new Object[]{"Description", DescribeConverterOperation.skipNull(descriptor.getDescription())});
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(4);
        DescribeConverterOperation.addColumn(result, "Property");
        DescribeConverterOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        String converterName;

        public Definition(String converterName) {
            super(DescribeConverterOperation.NAME);
            this.converterName = converterName;
        }
    }
}

