/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.cluster;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.cluster.AbstractClusterOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;

public class ListClustersOperation
extends AbstractClusterOperation {
    public static final String NAME = "list clusters";

    public ListClustersOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST CLUSTERS");
        this.syntax.setDescription("Shows a list of all clusters in the sysplex.");
        this.syntax.addTag(OperationTag.moderator);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        this.checkIsClustered();
        RowSet result = new RowSet(ListClustersOperation.createResultDescriptor());
        ((RuntimeContext)this.callable).getModerator().listClusters().forEach(name -> ListClustersOperation.add(result, new Object[]{name}));
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListClustersOperation.addColumn(result, "Nodes");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListClustersOperation.NAME);
        }
    }
}

