/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.cluster;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.cluster.AbstractClusterOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.exchange.FabricCluster;
import com.streamscape.sef.exchange.FabricClusterFactory;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.List;

public class DescribeClusterOperation
extends AbstractClusterOperation {
    public static final String NAME = "describe cluster";

    public DescribeClusterOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE CLUSTER");
        this.syntax.addActionParameter((SyntaxParameter)((IdentifierParameter)((IdentifierParameter)new IdentifierParameter("ClusterName").addExclusionValues("NODES", "PROPERTIES")).setRequired(false)).setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser(){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                return ((RuntimeContext)DescribeClusterOperation.this.callable).getModerator().listClusters();
            }
        }));
        this.syntax.addModifier((AbstractModifier)new Modifier("NODES", false).setSyntaxHintSpace());
        this.syntax.addModifier(new Modifier("PROPERTIES", false));
        this.syntax.setDescription("describe cluster               - Shows information about the cluster of the current node.\ndescribe cluster <ClusterName> - Shows information about the specified cluster.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n  nodes      - Shows a list of all nodes in the cluster.\n  properties - Shows a list of all properties of the cluster.");
        this.syntax.setExamples("describe cluster\ndescribe cluster Primary\ndescribe cluster nodes\ndescribe cluster Primary nodes");
        this.syntax.addTag(OperationTag.moderator);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("ClusterName") ? statement.getParameter("ClusterName").getValue() : null, statement.existsModifier("NODES"), statement.existsModifier("PROPERTIES"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.checkIsClustered();
        Definition definition = (Definition)statement;
        if (definition.clusterName == null) {
            definition.clusterName = ((RuntimeContext)this.callable).getClusterName();
        }
        String nodeName = null;
        if (!((RuntimeContext)this.callable).getClusterName().equals(definition.clusterName)) {
            if (!((RuntimeContext)this.callable).getModerator().listClusters().contains(definition.clusterName)) {
                throw new FabricException("Cluster not found.");
            }
            List<String> nodesInCluster = ((RuntimeContext)this.callable).getModerator().listFabricNodesInCluster(definition.clusterName);
            if (nodesInCluster.isEmpty()) {
                throw new FabricException("Cluster descriptor not available.");
            }
            nodeName = nodesInCluster.get(0);
        }
        return this.invoke(nodeName, definition, session, timeout);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(DescribeClusterOperation.createResultDescriptor(definition.nodes));
        if (definition.nodes) {
            ((RuntimeContext)this.callable).getModerator().listFabricNodesInCluster(definition.clusterName).forEach(name -> DescribeClusterOperation.add(result, new Object[]{name}));
        } else if (definition.properties) {
            FabricCluster cluster = FabricClusterFactory.getObjectFromRepository();
            if (cluster != null) {
                cluster.listProperties().forEach(propertyName -> DescribeClusterOperation.add(result, new Object[]{propertyName, cluster.getProperty((String)propertyName)}));
            }
        } else {
            result.addToRowSet(new Object[]{"Name", node.getClusterName()});
            FabricCluster cluster = FabricClusterFactory.getObjectFromRepository();
            if (cluster != null) {
                result.addToRowSet(new Object[]{"Description", DescribeClusterOperation.skipNull(cluster.getDescription())});
            }
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor(boolean nodes) {
        RowMetaData result = new RowMetaData();
        if (nodes) {
            DescribeClusterOperation.addColumn(result, "Nodes");
        } else {
            DescribeClusterOperation.addColumn(result, "Property");
            DescribeClusterOperation.addColumn(result, "Value");
        }
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        String clusterName;
        boolean nodes;
        boolean properties;

        public Definition(String clusterName, boolean nodes, boolean properties) {
            super(DescribeClusterOperation.NAME);
            this.clusterName = clusterName;
            this.nodes = nodes;
            this.properties = properties;
        }
    }
}

